/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.keystore.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidKeyStoreEntryPassword$str() {
        return "ELY02001: Invalid key store entry password for alias \"%s\"";
    }

    @Override
    public final UnrecoverableKeyException invalidKeyStoreEntryPassword(String alias) {
        UnrecoverableKeyException result2 = new UnrecoverableKeyException(String.format(this.getLoggingLocale(), this.invalidKeyStoreEntryPassword$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidKeyStoreEntryType$str() {
        return "ELY02002: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    }

    @Override
    public final KeyStoreException invalidKeyStoreEntryType(String alias, Class<?> expectedClass, Class<?> actualClass) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.invalidKeyStoreEntryType$str(), alias, expectedClass, actualClass));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyCannotBeProtected$str() {
        return "ELY02003: Key store key for alias \"%s\" cannot be protected";
    }

    @Override
    public final KeyStoreException keyCannotBeProtected(String alias) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.keyCannotBeProtected$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyStoreFailedToTranslate$str() {
        return "ELY02004: Key store failed to translate password for alias \"%s\"";
    }

    @Override
    public final IOException keyStoreFailedToTranslate(String alias, Throwable cause) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.keyStoreFailedToTranslate$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String noAlgorithmForPassword$str() {
        return "ELY02005: Key store failed to identify a suitable algorithm for alias \"%s\"";
    }

    @Override
    public final NoSuchAlgorithmException noAlgorithmForPassword(String alias) {
        NoSuchAlgorithmException result2 = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noAlgorithmForPassword$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unexpectedWhitespaceInPasswordFile$str() {
        return "ELY02006: Unexpected whitespace in password file";
    }

    @Override
    public final IOException unexpectedWhitespaceInPasswordFile() {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unexpectedWhitespaceInPasswordFile$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unexpectedEof$str() {
        return "ELY02007: Unexpected end of file";
    }

    @Override
    public final EOFException unexpectedEof() {
        EOFException result2 = new EOFException(String.format(this.getLoggingLocale(), this.unexpectedEof$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String reversibleLoadNotPossible$str() {
        return "ELY02008: A reversible load is not possible until the KeyStore has first been initialized";
    }

    @Override
    public final IllegalStateException reversibleLoadNotPossible() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.reversibleLoadNotPossible$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unableToCreateKeyStore$str() {
        return "ELY02009: Unable to create a new KeyStore instance";
    }

    @Override
    public final IOException unableToCreateKeyStore(Exception cause) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateKeyStore$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String emptyFilter$str() {
        return "ELY02012: An empty alias filter was supplied";
    }

    @Override
    public final IllegalArgumentException emptyFilter() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyFilter$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String missingPlusMinusAt$str() {
        return "ELY02013: Filter is missing '+' or '-' at offset %d";
    }

    @Override
    public final IllegalArgumentException missingPlusMinusAt(long position) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingPlusMinusAt$str(), position));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidFirstWord$str() {
        return "ELY02014: Invalid first word '%s', must be one of ALL/NONE";
    }

    @Override
    public final IllegalArgumentException invalidFirstWord(String firstWord) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidFirstWord$str(), firstWord));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failedToObtainDirContext$str() {
        return "ELY02015: Failed to obtain DirContext";
    }

    @Override
    public final IllegalStateException failedToObtainDirContext(Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToObtainDirContext$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failedToReturnDirContext$str() {
        return "ELY02016: Failed to return DirContext";
    }

    @Override
    public final IllegalStateException failedToReturnDirContext(Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToReturnDirContext$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainAlias$str() {
        return "ELY02017: LdapKeyStore failed to obtain alias [%s]";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAlias(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainAlias$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainCertificate$str() {
        return "ELY02018: LdapKeyStore failed to obtain certificate [%s]";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificate(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCertificate$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainCertificateChain$str() {
        return "ELY02019: LdapKeyStore failed to obtain certificate chain [%s]";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCertificateChain$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainKey$str() {
        return "ELY02020: LdapKeyStore failed to recover key of alias [%s]";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainKey(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainKey$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainAliasByCertificate$str() {
        return "ELY02021: LdapKeyStore failed to obtain alias by certificate";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainAliasByCertificate$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToRecoverKey$str() {
        return "ELY02022: LdapKeyStore failed to recover key of alias [%s]";
    }

    @Override
    public final UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(String alias, Throwable cause) {
        UnrecoverableKeyException result2 = new UnrecoverableKeyException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToRecoverKey$str(), alias));
        result2.initCause(cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToObtainCreationDate$str() {
        return "ELY02023: LdapKeyStore failed to obtain creation date of alias [%s]";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCreationDate(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCreationDate$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String creationNotConfigured$str() {
        return "ELY02024: Alias [%s] does not exist in LdapKeyStore and not configured for creation";
    }

    @Override
    public final KeyStoreException creationNotConfigured(String alias) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.creationNotConfigured$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToStore$str() {
        return "ELY02025: LdapKeyStore failed store alias [%s]";
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToStore(String alias, Throwable cause) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToStore$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToSerializeCertificate$str() {
        return "ELY02026: LdapKeyStore failed to serialize certificate of alias [%s]";
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeCertificate(String alias, Throwable cause) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToSerializeCertificate$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToSerializeKey$str() {
        return "ELY02027: LdapKeyStore failed to protect (pack into keystore) key of alias [%s]";
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeKey(String alias, Throwable cause) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToSerializeKey$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToDelete$str() {
        return "ELY02028: LdapKeyStore failed to delete alias [%s]";
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToDelete(String alias, Throwable cause) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToDelete$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToDeleteNonExisting$str() {
        return "ELY02029: LdapKeyStore failed to delete alias [%s] - alias not found";
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(String alias) {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToDeleteNonExisting$str(), alias));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToTestAliasExistence$str() {
        return "ELY02030: LdapKeyStore failed to test alias [%s] existence";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToTestAliasExistence(String alias, Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToTestAliasExistence$str(), alias), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String ldapKeyStoreFailedToIterateAliases$str() {
        return "ELY02031: LdapKeyStore failed to iterate aliases";
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToIterateAliases(Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToIterateAliases$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyStoreTypeNotDetected$str() {
        return "ELY02035: KeyStore type could not be detected";
    }

    @Override
    public final KeyStoreException keyStoreTypeNotDetected() {
        KeyStoreException result2 = new KeyStoreException(String.format(this.getLoggingLocale(), this.keyStoreTypeNotDetected$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return "ELY08027: Unknown password type or algorithm";
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result2 = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

