/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import org.wildfly.security.mechanism.ScramServerException;
import org.wildfly.security.mechanism._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void credentialDestroyingFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.credentialDestroyingFailed$str(), new Object[0]);
    }

    protected String credentialDestroyingFailed$str() {
        return "ELY00007: Credential destroying failed";
    }

    protected String authenticationFailedEvidenceVerification$str() {
        return "ELY01151: Evidence Verification Failed.";
    }

    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        SecurityException result2 = new SecurityException(String.format(this.getLoggingLocale(), this.authenticationFailedEvidenceVerification$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String mechMessageAfterComplete$str() {
        return "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    }

    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageAfterComplete$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUserNameContainsInvalidCharacter$str() {
        return "ELY05002: Authentication mechanism user name contains an invalid or disallowed character";
    }

    @Override
    public final AuthenticationMechanismException mechUserNameContainsInvalidCharacter() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUserNameContainsInvalidCharacter$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthorizationFailed0$str() {
        return "ELY05004: Authentication mechanism authorization failed";
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationFailed0$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationNotComplete$str() {
        return "ELY05005: Authentication mechanism authentication is not yet complete";
    }

    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.mechAuthenticationNotComplete$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoSecurityLayer$str() {
        return "ELY05006: Authentication mechanism does not support security layer (wrapping/unwrapping)";
    }

    @Override
    public final IllegalStateException mechNoSecurityLayer() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.mechNoSecurityLayer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidMessageReceived$str() {
        return "ELY05007: Invalid authentication mechanism negotiation message received";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidMessageReceived() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidMessageReceived$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoLoginNameGiven$str() {
        return "ELY05008: No authentication mechanism login name was given";
    }

    @Override
    public final AuthenticationMechanismException mechNoLoginNameGiven() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoLoginNameGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoPasswordGiven$str() {
        return "ELY05009: No authentication mechanism password was given";
    }

    @Override
    public final AuthenticationMechanismException mechNoPasswordGiven() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoPasswordGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMalformedFields$str() {
        return "ELY05010: Authentication mechanism authentication failed due to one or more malformed fields";
    }

    @Override
    public final AuthenticationMechanismException mechMalformedFields(IllegalArgumentException ex) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMalformedFields$str(), new Object[0]), ex);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMessageTooLong$str() {
        return "ELY05011: Authentication mechanism message is too long";
    }

    @Override
    public final AuthenticationMechanismException mechMessageTooLong() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageTooLong$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerSideAuthenticationFailed$str() {
        return "ELY05012: Authentication mechanism server-side authentication failed";
    }

    @Override
    public final AuthenticationMechanismException mechServerSideAuthenticationFailed(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerSideAuthenticationFailed$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechPasswordNotVerified$str() {
        return "ELY05013: Authentication mechanism password not verified";
    }

    @Override
    public final AuthenticationMechanismException mechPasswordNotVerified() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechPasswordNotVerified$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthorizationFailed2$str() {
        return "ELY05014: Authentication mechanism authorization failed: \"%s\" running as \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(String userName, String authorizationId) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationFailed2$str(), userName, authorizationId));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechChannelBindingChanged$str() {
        return "ELY05018: Channel binding data changed";
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingChanged() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingChanged$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoTokenGiven$str() {
        return "ELY05019: No token was given";
    }

    @Override
    public final AuthenticationMechanismException mechNoTokenGiven() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoTokenGiven$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInitialChallengeMustBeEmpty$str() {
        return "ELY05022: Initial challenge must be empty";
    }

    @Override
    public final AuthenticationMechanismException mechInitialChallengeMustBeEmpty() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInitialChallengeMustBeEmpty$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToSetChannelBinding$str() {
        return "ELY05023: Unable to set channel binding";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToSetChannelBinding(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToSetChannelBinding$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechFailedToDetermineChannelBindingStatus$str() {
        return "ELY05024: Failed to determine channel binding status";
    }

    @Override
    public final AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToDetermineChannelBindingStatus$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMutualAuthenticationNotEnabled$str() {
        return "ELY05025: Mutual authentication not enabled";
    }

    @Override
    public final AuthenticationMechanismException mechMutualAuthenticationNotEnabled() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMutualAuthenticationNotEnabled$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMechanismToOidMappingFailed$str() {
        return "ELY05026: Unable to map SASL mechanism name to a GSS-API OID";
    }

    @Override
    public final AuthenticationMechanismException mechMechanismToOidMappingFailed(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMechanismToOidMappingFailed$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToDisposeGssContext$str() {
        return "ELY05027: Unable to dispose of GSSContext";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDisposeGssContext(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDisposeGssContext$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToCreateNameForAcceptor$str() {
        return "ELY05028: Unable to create name for acceptor";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateNameForAcceptor(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateNameForAcceptor$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToCreateGssContext$str() {
        return "ELY05029: Unable to create GSSContext";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateGssContext(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateGssContext$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToSetGssContextRequestFlags$str() {
        return "ELY05030: Unable to set GSSContext request flags";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToSetGssContextRequestFlags$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToAcceptClientMessage$str() {
        return "ELY05031: Unable to accept SASL client message";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToAcceptClientMessage(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToAcceptClientMessage$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechGssApiMechanismMismatch$str() {
        return "ELY05032: GSS-API mechanism mismatch between SASL client and server";
    }

    @Override
    public final AuthenticationMechanismException mechGssApiMechanismMismatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechGssApiMechanismMismatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechChannelBindingNotSupported$str() {
        return "ELY05033: Channel binding not supported for this SASL mechanism";
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingNotSupported() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingNotSupported$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechChannelBindingTypeMismatch$str() {
        return "ELY05034: Channel binding type mismatch between SASL client and server";
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingTypeMismatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingTypeMismatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechChannelBindingNotProvided$str() {
        return "ELY05035: Channel binding not provided by client";
    }

    @Override
    public final AuthenticationMechanismException mechChannelBindingNotProvided() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechChannelBindingNotProvided$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToDeterminePeerName$str() {
        return "ELY05036: Unable to determine peer name";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDeterminePeerName(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDeterminePeerName$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechClientRefusesToInitiateAuthentication$str() {
        return "ELY05037: Authentication mechanism client refuses to initiate authentication";
    }

    @Override
    public final AuthenticationMechanismException mechClientRefusesToInitiateAuthentication() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientRefusesToInitiateAuthentication$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoncesDoNotMatch$str() {
        return "ELY05038: Nonces do not match";
    }

    @Override
    public final AuthenticationMechanismException mechNoncesDoNotMatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoncesDoNotMatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonceLength$str() {
        return "ELY05039: Invalid length of nonce received";
    }

    @Override
    public final AuthenticationMechanismException invalidNonceLength() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.invalidNonceLength$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechIterationCountIsTooLow$str() {
        return "ELY05040: Iteration count %d is below the minimum of %d";
    }

    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooLow(int iterationCount, int minimumIterationCount) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIterationCountIsTooLow$str(), iterationCount, minimumIterationCount));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechIterationCountIsTooHigh$str() {
        return "ELY05041: Iteration count %d is above the maximum of %d";
    }

    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooHigh(int iterationCount, int maximumIterationCount) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIterationCountIsTooHigh$str(), iterationCount, maximumIterationCount));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidServerMessage$str() {
        return "ELY05043: Invalid server message";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidServerMessage() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidServerMessage$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidServerMessageWithCause$str() {
        return "ELY05044: Invalid server message";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidServerMessageWithCause(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidServerMessageWithCause$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidClientMessage$str() {
        return "ELY05045: Invalid client message";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidClientMessage() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidClientMessage$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidClientMessageWithCause$str() {
        return "ELY05046: Invalid client message";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidClientMessageWithCause(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidClientMessageWithCause$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnmatchedMechanism$str() {
        return "ELY05047: [%s] Authentication mechanism message is for mismatched mechanism \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnmatchedMechanism(String mechName, String otherMechName) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnmatchedMechanism$str(), mechName, otherMechName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerAuthenticityCannotBeVerified$str() {
        return "ELY05049: Server authenticity cannot be verified";
    }

    @Override
    public final AuthenticationMechanismException mechServerAuthenticityCannotBeVerified() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerAuthenticityCannotBeVerified$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerDoesNotSupportUserName$str() {
        return "ELY05050: Callback handler does not support user name";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerDoesNotSupportUserName$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerDoesNotSupportCredentialAcquisition$str() {
        return "ELY05051: Callback handler does not support credential acquisition";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerDoesNotSupportCredentialAcquisition$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthorizationUnsupported$str() {
        return "ELY05052: Callback handler does not support authorization";
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationUnsupported(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationUnsupported$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return "ELY05053: Callback handler failed for unknown reason";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerFailedForUnknownReason$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationRejectedInvalidProof$str() {
        return "ELY05055: Authentication rejected (invalid proof)";
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationRejectedInvalidProof() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationRejectedInvalidProof$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechClientSentExtraMessage$str() {
        return "ELY05056: Client sent extra message";
    }

    @Override
    public final AuthenticationMechanismException mechClientSentExtraMessage() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientSentExtraMessage$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerSentExtraMessage$str() {
        return "ELY05057: Server sent extra message";
    }

    @Override
    public final AuthenticationMechanismException mechServerSentExtraMessage() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerSentExtraMessage$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationFailed$str() {
        return "ELY05058: Authentication failed";
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationFailed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String emptyNumber$str() {
        return "ELY05060: Empty number";
    }

    @Override
    public final NumberFormatException emptyNumber() {
        NumberFormatException result2 = new NumberFormatException(String.format(this.getLoggingLocale(), this.emptyNumber$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNumericCharacter$str() {
        return "ELY05061: Invalid numeric character";
    }

    @Override
    public final NumberFormatException invalidNumericCharacter() {
        NumberFormatException result2 = new NumberFormatException(String.format(this.getLoggingLocale(), this.invalidNumericCharacter$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String tooBigNumber$str() {
        return "ELY05062: Too big number";
    }

    @Override
    public final NumberFormatException tooBigNumber() {
        NumberFormatException result2 = new NumberFormatException(String.format(this.getLoggingLocale(), this.tooBigNumber$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCannotGetTwoWayPasswordChars$str() {
        return "ELY05063: Cannot get clear password from two way password";
    }

    @Override
    public final AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCannotGetTwoWayPasswordChars$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMacAlgorithmNotSupported$str() {
        return "ELY05064: Hashing algorithm not supported";
    }

    @Override
    public final AuthenticationMechanismException mechMacAlgorithmNotSupported(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMacAlgorithmNotSupported$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechKeywordCannotBeEmpty$str() {
        return "ELY05065: keyword cannot be empty";
    }

    @Override
    public final AuthenticationMechanismException mechKeywordCannotBeEmpty() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechKeywordCannotBeEmpty$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoValueFoundForKeyword$str() {
        return "ELY05066: No value found for keyword: %s";
    }

    @Override
    public final AuthenticationMechanismException mechNoValueFoundForKeyword(String keyword) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoValueFoundForKeyword$str(), keyword));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechKeywordNotFollowedByEqual$str() {
        return "ELY05067: '=' expected after keyword: %s";
    }

    @Override
    public final AuthenticationMechanismException mechKeywordNotFollowedByEqual(String keyword) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechKeywordNotFollowedByEqual$str(), keyword));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnmatchedQuoteFoundForValue$str() {
        return "ELY05068: Unmatched quote found for value: %s";
    }

    @Override
    public final AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(String value) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnmatchedQuoteFoundForValue$str(), value));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechExpectingCommaOrLinearWhitespaceAfterQuoted$str() {
        return "ELY05069: Expecting comma or linear whitespace after quoted string: %s";
    }

    @Override
    public final AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(String value) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechExpectingCommaOrLinearWhitespaceAfterQuoted$str(), value));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMessageTypeMustEqual$str() {
        return "ELY05070: MessageType must equal to %d, but it is %d";
    }

    @Override
    public final AuthenticationMechanismException mechMessageTypeMustEqual(int expected, int actual) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMessageTypeMustEqual$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechBadSequenceNumberWhileUnwrapping$str() {
        return "ELY05071: Bad sequence number while unwrapping: expected %d, but %d received";
    }

    @Override
    public final AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(int expected, int actual) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechBadSequenceNumberWhileUnwrapping$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechProblemDuringCrypt$str() {
        return "ELY05072: Problem during crypt";
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringCrypt(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringCrypt$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechProblemDuringDecrypt$str() {
        return "ELY05073: Problem during decrypt";
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringDecrypt(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringDecrypt$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnknownCipher$str() {
        return "ELY05074: Unknown cipher \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnknownCipher(String cipher) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnknownCipher$str(), cipher));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthorizationIdChanged$str() {
        return "ELY05075: Authorization ID changed unexpectedly";
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationIdChanged() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationIdChanged$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechProblemGettingRequiredCipher$str() {
        return "ELY05076: Problem getting required cipher. Check your transformation mapper settings.";
    }

    @Override
    public final AuthenticationMechanismException mechProblemGettingRequiredCipher(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemGettingRequiredCipher$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoCommonProtectionLayer$str() {
        return "ELY05077: No common protection layer between client and server";
    }

    @Override
    public final AuthenticationMechanismException mechNoCommonProtectionLayer() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCommonProtectionLayer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoCommonCipher$str() {
        return "ELY05078: No common cipher between client and server";
    }

    @Override
    public final AuthenticationMechanismException mechNoCommonCipher() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCommonCipher$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoCiphersOfferedByServer$str() {
        return "ELY05079: No ciphers offered by server";
    }

    @Override
    public final AuthenticationMechanismException mechNoCiphersOfferedByServer() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoCiphersOfferedByServer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNotProvidedUserName$str() {
        return "ELY05080: Callback handler not provided user name";
    }

    @Override
    public final AuthenticationMechanismException mechNotProvidedUserName() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNotProvidedUserName$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMissingDirective$str() {
        return "ELY05083: Missing \"%s\" directive";
    }

    @Override
    public final AuthenticationMechanismException mechMissingDirective(String directive) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMissingDirective$str(), directive));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNonceCountMustEqual$str() {
        return "ELY05084: nonce-count must equal to %d, but it is %d";
    }

    @Override
    public final AuthenticationMechanismException mechNonceCountMustEqual(int expected, int actual) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNonceCountMustEqual$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnsupportedCharset$str() {
        return "ELY05085: Server is set to not support %s charset";
    }

    @Override
    public final AuthenticationMechanismException mechUnsupportedCharset(String charset) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnsupportedCharset$str(), charset));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnknownCharset$str() {
        return "ELY05086: Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)";
    }

    @Override
    public final AuthenticationMechanismException mechUnknownCharset() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnknownCharset$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechDisallowedClientRealm$str() {
        return "ELY05087: Client selected realm not offered by server (%s)";
    }

    @Override
    public final AuthenticationMechanismException mechDisallowedClientRealm(String clientRealm) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechDisallowedClientRealm$str(), clientRealm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechMismatchedWrongDigestUri$str() {
        return "ELY05088: digest-uri \"%s\" not accepted";
    }

    @Override
    public final AuthenticationMechanismException mechMismatchedWrongDigestUri(String actual) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechMismatchedWrongDigestUri$str(), actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnexpectedQop$str() {
        return "ELY05089: Unexpected qop value: \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnexpectedQop(String qop) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnexpectedQop$str(), qop));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String wrappingNotConfigured$str() {
        return "ELY05090: Wrapping is not configured";
    }

    @Override
    public final IllegalStateException wrappingNotConfigured() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.wrappingNotConfigured$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationNameTooLong$str() {
        return "ELY05091: Authentication name string is too long";
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationNameTooLong() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationNameTooLong$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthenticationNameIsEmpty$str() {
        return "ELY05092: Authentication name is empty";
    }

    @Override
    public final AuthenticationMechanismException mechAuthenticationNameIsEmpty() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthenticationNameIsEmpty$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAnonymousAuthorizationDenied$str() {
        return "ELY05093: Authorization for anonymous access is denied";
    }

    @Override
    public final AuthenticationMechanismException mechAnonymousAuthorizationDenied() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAnonymousAuthorizationDenied$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String requiredNegativePadding$str() {
        return "ELY05094: Required padded length (%d) is less than length of conversion result (%d)";
    }

    @Override
    public final IllegalArgumentException requiredNegativePadding(int totalLength, int hexLength) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.requiredNegativePadding$str(), totalLength, hexLength));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidKeyForDigestHMAC$str() {
        return "ELY05095: Invalid key provided for Digest HMAC computing";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidKeyForDigestHMAC() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidKeyForDigestHMAC$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unableToDetermineSubjectName$str() {
        return "ELY05097: Unable to determine subject name from X.509 certificate";
    }

    @Override
    public final IllegalStateException unableToDetermineSubjectName(Throwable cause) {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToDetermineSubjectName$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToVerifyClientSignature$str() {
        return "ELY05098: Unable to verify client signature";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToVerifyClientSignature(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToVerifyClientSignature$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToVerifyServerSignature$str() {
        return "ELY05099: Unable to verify server signature";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToVerifyServerSignature(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToVerifyServerSignature$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerNotProvidedServerCertificate$str() {
        return "ELY05101: Callback handler not provided server certificate";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedServerCertificate$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerNotProvidedClientCertificate$str() {
        return "ELY05102: Callback handler not provided client certificate";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedClientCertificate$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerIdentifierMismatch$str() {
        return "ELY05103: Server identifier mismatch";
    }

    @Override
    public final AuthenticationMechanismException mechServerIdentifierMismatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerIdentifierMismatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechClientIdentifierMismatch$str() {
        return "ELY05104: Client identifier mismatch";
    }

    @Override
    public final AuthenticationMechanismException mechClientIdentifierMismatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechClientIdentifierMismatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToDetermineClientName$str() {
        return "ELY05105: Unable to determine client name";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDetermineClientName(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDetermineClientName$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerNotProvidedPrivateKey$str() {
        return "ELY05106: Callback handler not provided private key";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerNotProvidedPrivateKey$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToCreateSignature$str() {
        return "ELY05107: Unable to create signature";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateSignature(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateSignature$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToCreateResponseToken$str() {
        return "ELY05108: Unable to create response token";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseToken(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateResponseToken$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToCreateResponseTokenWithCause$str() {
        return "ELY05109: Unable to create response token";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToCreateResponseTokenWithCause$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechGettingSupportedMechanismsFailed$str() {
        return "ELY05112: Getting authentication mechanisms supported by GSS-API failed";
    }

    @Override
    public final AuthenticationMechanismException mechGettingSupportedMechanismsFailed(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechGettingSupportedMechanismsFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unableToInitialiseOid$str() {
        return "ELY05113: Unable to initialize OID of Kerberos V5";
    }

    @Override
    public final RuntimeException unableToInitialiseOid(Throwable cause) {
        RuntimeException result2 = new RuntimeException(String.format(this.getLoggingLocale(), this.unableToInitialiseOid$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechReceiveBufferIsGreaterThanMaximum$str() {
        return "ELY05114: Receive buffer requested '%d' is greater than supported maximum '%d'";
    }

    @Override
    public final AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(int requested, int maximum) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechReceiveBufferIsGreaterThanMaximum$str(), requested, maximum));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToWrapMessage$str() {
        return "ELY05115: Unable to wrap message";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToWrapMessage(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToWrapMessage$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToUnwrapMessage$str() {
        return "ELY05116: Unable to unwrap message";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapMessage(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUnwrapMessage$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToUnwrapSecurityLayerNegotiationMessage$str() {
        return "ELY05117: Unable to unwrap security layer negotiation message";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUnwrapSecurityLayerNegotiationMessage$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidMessageOnUnwrapping$str() {
        return "ELY05118: Invalid message of length %d on unwrapping";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidMessageOnUnwrapping(int length) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidMessageOnUnwrapping$str(), length));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNegotiatedMechanismWasNotKerberosV5$str() {
        return "ELY05119: Negotiated mechanism was not Kerberos V5";
    }

    @Override
    public final AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNegotiatedMechanismWasNotKerberosV5$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInsufficientQopsAvailable$str() {
        return "ELY05120: Insufficient levels of protection available for supported security layers";
    }

    @Override
    public final AuthenticationMechanismException mechInsufficientQopsAvailable() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInsufficientQopsAvailable$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToGenerateChallenge$str() {
        return "ELY05121: Unable to generate security layer challenge";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToGenerateChallenge(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToGenerateChallenge$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechSelectedUnofferedQop$str() {
        return "ELY05122: Client selected a security layer that was not offered by server";
    }

    @Override
    public final AuthenticationMechanismException mechSelectedUnofferedQop() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechSelectedUnofferedQop$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNoSecurityLayerButLengthReceived$str() {
        return "ELY05123: No security layer selected but message length received";
    }

    @Override
    public final AuthenticationMechanismException mechNoSecurityLayerButLengthReceived() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNoSecurityLayerButLengthReceived$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToGetMaximumSizeOfMessage$str() {
        return "ELY05124: Unable to get maximum size of message before wrap";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToGetMaximumSizeOfMessage$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToHandleResponseFromServer$str() {
        return "ELY05125: Unable to handle response from server";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToHandleResponseFromServer(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToHandleResponseFromServer$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechBadLengthOfMessageForNegotiatingSecurityLayer$str() {
        return "ELY05126: Bad length of message for negotiating security layer";
    }

    @Override
    public final AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechBadLengthOfMessageForNegotiatingSecurityLayer$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechReceivedMaxMessageSizeWhenNoSecurityLayer$str() {
        return "ELY05127: No security layer supported by server but maximum message size received: \"%d\"";
    }

    @Override
    public final AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(int length) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechReceivedMaxMessageSizeWhenNoSecurityLayer$str(), length));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechFailedToReadChallengeFile$str() {
        return "ELY05128: Failed to read challenge file";
    }

    @Override
    public final AuthenticationMechanismException mechFailedToReadChallengeFile(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToReadChallengeFile$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechFailedToCreateChallengeFile$str() {
        return "ELY05129: Failed to create challenge file";
    }

    @Override
    public final AuthenticationMechanismException mechFailedToCreateChallengeFile(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechFailedToCreateChallengeFile$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechAuthorizationIdTooLong$str() {
        return "ELY05150: Authentication mechanism authorization ID is too long";
    }

    @Override
    public final AuthenticationMechanismException mechAuthorizationIdTooLong() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechAuthorizationIdTooLong$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlgorithm(String algorithm) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPResponseType$str() {
        return "ELY05152: Invalid OTP response type";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPResponseType() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPResponseType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechIncorrectParity$str() {
        return "ELY05153: Incorrect parity in SASL client message";
    }

    @Override
    public final AuthenticationMechanismException mechIncorrectParity() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechIncorrectParity$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidCharacterInSeed$str() {
        return "ELY05154: Invalid character in seed";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidCharacterInSeed() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidCharacterInSeed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPSeed$str() {
        return "ELY05155: Invalid OTP seed, must be between 1 and 16 characters long";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPSeed() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPSeed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPPassPhrase$str() {
        return "ELY05156: Invalid OTP pass phrase, must be between 10 and 63 characters long";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPPassPhrase() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPPassPhrase$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPSequenceNumber$str() {
        return "ELY05157: Invalid OTP sequence number";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPSequenceNumber() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPSequenceNumber$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTP$str() {
        return "ELY05158: Invalid OTP";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTP() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTP$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechOTPPassPhraseAndSeedMustNotMatch$str() {
        return "ELY05159: OTP pass phrase and seed must not match";
    }

    @Override
    public final AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOTPPassPhraseAndSeedMustNotMatch$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPAlternateDictionary$str() {
        return "ELY05160: Invalid OTP alternate dictionary";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlternateDictionary() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlternateDictionary$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToRetrievePassword$str() {
        return "ELY05161: Unable to retrieve password for \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToRetrievePassword(String userName) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToRetrievePassword$str(), userName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToUpdatePassword$str() {
        return "ELY05162: Unable to update password for \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToUpdatePassword(String userName) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToUpdatePassword$str(), userName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechServerTimedOut$str() {
        return "ELY05163: Authentication mechanism server timed out";
    }

    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechServerTimedOut$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToObtainExclusiveAccess$str() {
        return "ELY05164: Unable to obtain exclusive access for \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToObtainExclusiveAccess(String userName) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToObtainExclusiveAccess$str(), userName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechOTPReinitializationFailed$str() {
        return "ELY05165: OTP re-initialization failed";
    }

    @Override
    public final AuthenticationMechanismException mechOTPReinitializationFailed(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOTPReinitializationFailed$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String scramServerRejectedAuthentication$str() {
        return "ELY05166: Server rejected authentication";
    }

    @Override
    public final ScramServerException scramServerRejectedAuthentication(ScramServerErrorCode errorCode) {
        ScramServerException result2 = new ScramServerException(String.format(this.getLoggingLocale(), this.scramServerRejectedAuthentication$str(), new Object[0]), errorCode);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechInvalidOTPPasswordFormatType$str() {
        return "ELY05167: Invalid OTP password format type";
    }

    @Override
    public final AuthenticationMechanismException mechInvalidOTPPasswordFormatType() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechInvalidOTPPasswordFormatType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnsupportedAlgorithm$str() {
        return "ELY05168: Unsupported algorithm selected \"%s\"";
    }

    @Override
    public final AuthenticationMechanismException mechUnsupportedAlgorithm(String algorithm) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnsupportedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechResponseTokenMismatch$str() {
        return "ELY05169: [%s] Clients response token does not match expected token";
    }

    @Override
    public final String mechResponseTokenMismatch(String mechName) {
        return String.format(this.getLoggingLocale(), this.mechResponseTokenMismatch$str(), mechName);
    }

    protected String mechProblemDuringCryptResultIsNull$str() {
        return "ELY05170: Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.";
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringCryptResultIsNull() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringCryptResultIsNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechProblemDuringDecryptResultIsNull$str() {
        return "ELY05171: Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.";
    }

    @Override
    public final AuthenticationMechanismException mechProblemDuringDecryptResultIsNull() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechProblemDuringDecryptResultIsNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unableToObtainServerCredential$str() {
        return "ELY05173: Unable to obtain server credential.";
    }

    @Override
    public final AuthenticationMechanismException unableToObtainServerCredential() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.unableToObtainServerCredential$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechNotChosenRealm$str() {
        return "ELY05174: Callback handler has not chosen realm";
    }

    @Override
    public final AuthenticationMechanismException mechNotChosenRealm() {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechNotChosenRealm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechUnableToDetermineBoundServerName$str() {
        return "ELY05175: Unable to determine bound server name";
    }

    @Override
    public final AuthenticationMechanismException mechUnableToDetermineBoundServerName(Exception e) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechUnableToDetermineBoundServerName$str(), new Object[0]), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechCallbackHandlerUnsupportedCallback$str() {
        return "ELY05176: Unsupported callback";
    }

    @Override
    public final AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(Throwable cause) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechCallbackHandlerUnsupportedCallback$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechOneOfDirectivesHasToBeDefined$str() {
        return "ELY05177: One of \"%s\" and \"%s\" directives has to be defined";
    }

    @Override
    public final AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(String directive1, String directive2) {
        AuthenticationMechanismException result2 = new AuthenticationMechanismException(String.format(this.getLoggingLocale(), this.mechOneOfDirectivesHasToBeDefined$str(), directive1, directive2));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String incorrectlyFormattedHeader$str() {
        return "ELY06001: An incorrectly formatted '%s'header was encountered.";
    }

    @Override
    public final String incorrectlyFormattedHeader(String headerName) {
        return String.format(this.getLoggingLocale(), this.incorrectlyFormattedHeader$str(), headerName);
    }

    protected String authenticationFailed2$str() {
        return "ELY06002: An authentication attempt for user '%s' failed validation using mechanism '%s'.";
    }

    @Override
    public final String authenticationFailed(String username, String mechanismName) {
        return String.format(this.getLoggingLocale(), this.authenticationFailed2$str(), username, mechanismName);
    }

    protected String authenticationFailed0$str() {
        return "ELY06003: An authentication attempt failed validation.";
    }

    @Override
    public final String authenticationFailed() {
        return String.format(this.getLoggingLocale(), this.authenticationFailed0$str(), new Object[0]);
    }

    protected String authorizationFailed$str() {
        return "ELY06006: An authorization check for user '%s' failed.";
    }

    @Override
    public final String authorizationFailed(String username) {
        return String.format(this.getLoggingLocale(), this.authorizationFailed$str(), username);
    }

    protected String usernameOrPasswordMissing$str() {
        return "ELY06007: Username or password missing from authentication attempt.";
    }

    @Override
    public final String usernameOrPasswordMissing() {
        return String.format(this.getLoggingLocale(), this.usernameOrPasswordMissing$str(), new Object[0]);
    }

    protected String digestMechanismRequireRealm$str() {
        return "ELY06015: Unable to authenticate using DIGEST mechanism - realm name needs to be specified";
    }

    @Override
    public final HttpAuthenticationException digestMechanismRequireRealm() {
        HttpAuthenticationException result2 = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.digestMechanismRequireRealm$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String digestMechanismInvalidRealm$str() {
        return "ELY06019: Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid";
    }

    @Override
    public final HttpAuthenticationException digestMechanismInvalidRealm(String realm) {
        HttpAuthenticationException result2 = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.digestMechanismInvalidRealm$str(), realm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unsuitableScope$str() {
        return "ELY06020: Scope unsuitable for use with authentication state '%s'";
    }

    @Override
    public final IllegalArgumentException unsuitableScope(String scopeName) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsuitableScope$str(), scopeName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unableToIdentifyHttpScope$str() {
        return "ELY06021: Unable to identify suitable HttpScope for mechanism state storage";
    }

    @Override
    public final IllegalArgumentException unableToIdentifyHttpScope() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToIdentifyHttpScope$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidNonceCount$str() {
        return "ELY06022: Invalid nonce count %s";
    }

    @Override
    public final HttpAuthenticationException invalidNonceCount(int nonceCount) {
        HttpAuthenticationException result2 = new HttpAuthenticationException(String.format(this.getLoggingLocale(), this.invalidNonceCount$str(), nonceCount));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result2 = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String asnInvalidGeneralNameType$str() {
        return "ELY07002: Invalid general name type";
    }

    @Override
    public final ASN1Exception asnInvalidGeneralNameType() {
        ASN1Exception result2 = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnInvalidGeneralNameType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result2 = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

