/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import protostream.com.squareup.protoparser.AutoValue_MessageElement;
import protostream.com.squareup.protoparser.EnumElement;
import protostream.com.squareup.protoparser.ExtensionsElement;
import protostream.com.squareup.protoparser.FieldElement;
import protostream.com.squareup.protoparser.OneOfElement;
import protostream.com.squareup.protoparser.OptionElement;
import protostream.com.squareup.protoparser.TypeElement;
import protostream.com.squareup.protoparser.Utils;

public abstract class MessageElement
implements TypeElement {
    static void validateFieldTagUniqueness(String qualifiedName, List<FieldElement> fields, List<OneOfElement> oneOfs) {
        ArrayList<FieldElement> allFields = new ArrayList<FieldElement>(fields);
        for (OneOfElement oneOf : oneOfs) {
            allFields.addAll(oneOf.fields());
        }
        LinkedHashSet<Integer> tags = new LinkedHashSet<Integer>();
        for (FieldElement field2 : allFields) {
            int tag = field2.tag();
            if (tags.add(tag)) continue;
            throw new IllegalStateException("Duplicate tag " + tag + " in " + qualifiedName);
        }
    }

    static void validateFieldLabel(String qualifiedName, List<FieldElement> fields) {
        for (FieldElement field2 : fields) {
            if (field2.label() != FieldElement.Label.ONE_OF) continue;
            throw new IllegalStateException("Field '" + field2.name() + "' in " + qualifiedName + " improperly declares itself a member of a 'oneof' group but is not.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    MessageElement() {
    }

    @Override
    public abstract String name();

    @Override
    public abstract String qualifiedName();

    @Override
    public abstract String documentation();

    public abstract List<FieldElement> fields();

    public abstract List<OneOfElement> oneOfs();

    @Override
    public abstract List<TypeElement> nestedElements();

    public abstract List<ExtensionsElement> extensions();

    @Override
    public abstract List<OptionElement> options();

    @Override
    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("message ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Utils.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.fields().isEmpty()) {
            builder.append('\n');
            for (FieldElement field2 : this.fields()) {
                Utils.appendIndented(builder, field2.toSchema());
            }
        }
        if (!this.oneOfs().isEmpty()) {
            builder.append('\n');
            for (OneOfElement oneOf : this.oneOfs()) {
                Utils.appendIndented(builder, oneOf.toSchema());
            }
        }
        if (!this.extensions().isEmpty()) {
            builder.append('\n');
            for (ExtensionsElement extension : this.extensions()) {
                Utils.appendIndented(builder, extension.toSchema());
            }
        }
        if (!this.nestedElements().isEmpty()) {
            builder.append('\n');
            for (TypeElement type : this.nestedElements()) {
                Utils.appendIndented(builder, type.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Builder {
        private String name;
        private String qualifiedName;
        private String documentation = "";
        private final List<FieldElement> fields = new ArrayList<FieldElement>();
        private final List<OneOfElement> oneOfs = new ArrayList<OneOfElement>();
        private final List<TypeElement> nestedElements = new ArrayList<TypeElement>();
        private final List<ExtensionsElement> extensions = new ArrayList<ExtensionsElement>();
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            if (this.qualifiedName == null) {
                this.qualifiedName = name;
            }
            return this;
        }

        public Builder qualifiedName(String qualifiedName) {
            this.qualifiedName = Utils.checkNotNull(qualifiedName, "qualifiedName");
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addField(FieldElement field2) {
            this.fields.add(Utils.checkNotNull(field2, "field"));
            return this;
        }

        public Builder addFields(Collection<FieldElement> fields) {
            for (FieldElement field2 : Utils.checkNotNull(fields, "fields")) {
                this.addField(field2);
            }
            return this;
        }

        public Builder addOneOf(OneOfElement oneOf) {
            this.oneOfs.add(Utils.checkNotNull(oneOf, "oneOf"));
            return this;
        }

        public Builder addOneOfs(Collection<OneOfElement> oneOfs) {
            for (OneOfElement oneOf : Utils.checkNotNull(oneOfs, "oneOfs")) {
                this.addOneOf(oneOf);
            }
            return this;
        }

        public Builder addType(TypeElement type) {
            this.nestedElements.add(Utils.checkNotNull(type, "type"));
            return this;
        }

        public Builder addTypes(Collection<TypeElement> types) {
            for (TypeElement type : Utils.checkNotNull(types, "types")) {
                this.addType(type);
            }
            return this;
        }

        public Builder addExtensions(ExtensionsElement extensions) {
            this.extensions.add(Utils.checkNotNull(extensions, "extensions"));
            return this;
        }

        public Builder addExtensions(Collection<ExtensionsElement> extensions) {
            for (ExtensionsElement extension : Utils.checkNotNull(extensions, "extensions")) {
                this.addExtensions(extension);
            }
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public MessageElement build() {
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.qualifiedName, "qualifiedName");
            MessageElement.validateFieldTagUniqueness(this.qualifiedName, this.fields, this.oneOfs);
            MessageElement.validateFieldLabel(this.qualifiedName, this.fields);
            EnumElement.validateValueUniquenessInScope(this.qualifiedName, this.nestedElements);
            return new AutoValue_MessageElement(this.name, this.qualifiedName, this.documentation, Utils.immutableCopyOf(this.fields), Utils.immutableCopyOf(this.oneOfs), Utils.immutableCopyOf(this.nestedElements), Utils.immutableCopyOf(this.extensions), Utils.immutableCopyOf(this.options));
        }
    }
}

