/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage.propagation;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.propagation.Parser;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class W3CBaggagePropagator
implements TextMapPropagator {
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private static final W3CBaggagePropagator INSTANCE = new W3CBaggagePropagator();

    public static W3CBaggagePropagator getInstance() {
        return INSTANCE;
    }

    private W3CBaggagePropagator() {
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter2) {
        if (context == null || setter2 == null) {
            return;
        }
        Baggage baggage = Baggage.fromContext(context);
        if (baggage.isEmpty()) {
            return;
        }
        StringBuilder headerContent = new StringBuilder();
        baggage.forEach((key, baggageEntry) -> {
            headerContent.append((String)key).append("=").append(baggageEntry.getValue());
            String metadataValue = baggageEntry.getMetadata().getValue();
            if (metadataValue != null && !metadataValue.isEmpty()) {
                headerContent.append(";").append(metadataValue);
            }
            headerContent.append(",");
        });
        if (headerContent.length() > 0) {
            headerContent.setLength(headerContent.length() - 1);
            setter2.set(carrier, FIELD, headerContent.toString());
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter2) {
        if (context == null) {
            return Context.root();
        }
        if (getter2 == null) {
            return context;
        }
        String baggageHeader = getter2.get(carrier, FIELD);
        if (baggageHeader == null) {
            return context;
        }
        if (baggageHeader.isEmpty()) {
            return context;
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            W3CBaggagePropagator.extractEntries(baggageHeader, baggageBuilder);
        }
        catch (RuntimeException e) {
            return context;
        }
        return context.with(baggageBuilder.build());
    }

    private static void extractEntries(String baggageHeader, BaggageBuilder baggageBuilder) {
        new Parser(baggageHeader).parseInto(baggageBuilder);
    }
}

