/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime;

import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.ApplicationConfig;
import io.smallrye.common.annotation.Identifier;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.Config;

@Singleton
public class KafkaRuntimeConfigProducer {
    private static final String CONFIG_PREFIX = "kafka";
    private static final String GROUP_ID = "group.id";

    @Produces
    @DefaultBean
    @Singleton
    @Identifier(value="default-kafka-broker")
    public Map<String, Object> createKafkaRuntimeConfig(Config config, ApplicationConfig app) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        for (String propertyName : config.getPropertyNames()) {
            String propertyNameLowerCase = propertyName.toLowerCase();
            if (!propertyNameLowerCase.startsWith(CONFIG_PREFIX)) continue;
            String effectivePropertyName = propertyNameLowerCase.substring(CONFIG_PREFIX.length() + 1).toLowerCase().replace("_", ".");
            String value = config.getOptionalValue(propertyName, String.class).orElse("");
            result2.put(effectivePropertyName, value);
        }
        if (!result2.isEmpty() && !result2.containsKey(GROUP_ID) && app.name.isPresent()) {
            result2.put(GROUP_ID, app.name.get());
        }
        return result2;
    }
}

