/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.graal.DiagnosticPrinter;
import java.net.BindException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.wildfly.common.lock.Locks;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ApplicationLifecycleManager {
    private static volatile BiConsumer<Integer, Throwable> defaultExitCodeHandler = new BiConsumer<Integer, Throwable>(){

        @Override
        public void accept(Integer integer, Throwable cause) {
            System.exit(integer);
        }
    };
    private static final String DISABLE_SIGNAL_HANDLERS = "DISABLE_SIGNAL_HANDLERS";
    private static final Lock stateLock = Locks.reentrantLock();
    private static final Condition stateCond = stateLock.newCondition();
    private static ShutdownHookThread shutdownHookThread;
    private static int exitCode;
    private static volatile boolean shutdownRequested;
    private static Application currentApplication;
    private static boolean hooksRegistered;
    private static boolean vmShuttingDown;
    private static final boolean IS_WINDOWS;
    private static final boolean IS_MAC;

    private ApplicationLifecycleManager() {
    }

    public static void run(Application application, String ... args) {
        ApplicationLifecycleManager.run(application, null, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Application application, Class<? extends QuarkusApplication> quarkusApplication, BiConsumer<Integer, Throwable> exitCodeHandler, String ... args) {
        boolean alreadyStarted;
        block55: {
            stateLock.lock();
            alreadyStarted = application.isStarted();
            if (shutdownHookThread == null) {
                ApplicationLifecycleManager.registerHooks(exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler);
            }
            if (currentApplication != null && !shutdownRequested) {
                throw new IllegalStateException("Quarkus already running");
            }
            try {
                exitCode = -1;
                shutdownRequested = false;
                currentApplication = application;
            }
            finally {
                stateLock.unlock();
            }
            try {
                application.start(args);
                if (quarkusApplication != null) {
                    QuarkusApplication instance;
                    BeanManager beanManager = CDI.current().getBeanManager();
                    Set<Bean<?>> beans = beanManager.getBeans(quarkusApplication, Any.Literal.INSTANCE);
                    Bean<?> bean = null;
                    for (Bean<?> i : beans) {
                        if (i.getBeanClass() != quarkusApplication) continue;
                        bean = i;
                        break;
                    }
                    if (bean == null) {
                        instance = quarkusApplication.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        CreationalContext ctx = beanManager.createCreationalContext(bean);
                        instance = (QuarkusApplication)beanManager.getReference(bean, quarkusApplication, ctx);
                    }
                    int result2 = -1;
                    try {
                        result2 = instance.run(args);
                        break block55;
                    }
                    finally {
                        stateLock.lock();
                        try {
                            if (exitCode == -1 && result2 != -1) {
                                exitCode = result2;
                            }
                            shutdownRequested = true;
                            stateCond.signalAll();
                        }
                        finally {
                            stateLock.unlock();
                        }
                    }
                }
                ApplicationLifecycleManager.longLivedPostBootCleanup();
                stateLock.lock();
                try {
                    while (!shutdownRequested) {
                        Thread.interrupted();
                        stateCond.awaitUninterruptibly();
                    }
                }
                finally {
                    stateLock.unlock();
                }
            }
            catch (Exception e) {
                if (exitCodeHandler == null) {
                    Throwable rootCause = e;
                    while (rootCause.getCause() != null) {
                        rootCause = rootCause.getCause();
                    }
                    Logger applicationLogger = Logger.getLogger(Application.class);
                    if (rootCause instanceof BindException) {
                        Config config = ConfigProviderResolver.instance().getConfig();
                        Integer port = null;
                        Integer sslPort = null;
                        if (config.getOptionalValue("quarkus.http.insecure-requests", String.class).orElse("").equalsIgnoreCase("disabled")) {
                            port = config.getOptionalValue("quarkus.http.ssl-port", Integer.class).orElse(8443);
                            applicationLogger.errorf("Port %d seems to be in use by another process. Quarkus may already be running or the port is used by another application.", (Object)port);
                        } else if (config.getOptionalValue("quarkus.http.ssl.certificate.file", String.class).isPresent() || config.getOptionalValue("quarkus.http.ssl.certificate.key-file", String.class).isPresent() || config.getOptionalValue("quarkus.http.ssl.certificate.key-store-file", String.class).isPresent()) {
                            port = config.getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
                            sslPort = config.getOptionalValue("quarkus.http.ssl-port", Integer.class).orElse(8443);
                            applicationLogger.errorf("Either port %d or port %d seem to be in use by another process. Quarkus may already be running or one of the ports is used by another application.", (Object)port, (Object)sslPort);
                        } else {
                            port = config.getOptionalValue("quarkus.http.port", Integer.class).orElse(8080);
                            applicationLogger.errorf("Port %d seems to be in use by another process. Quarkus may already be running or the port is used by another application.", (Object)port);
                        }
                        if (IS_WINDOWS) {
                            applicationLogger.warn("Use 'netstat -a -b -n -o' to identify the process occupying the port.");
                            applicationLogger.warn("You can try to kill it with 'taskkill /PID <pid>' or via the Task Manager.");
                        } else if (IS_MAC) {
                            applicationLogger.warnf("Use 'netstat -anv | grep %d' to identify the process occupying the port.", (Object)port);
                            if (sslPort != null) {
                                applicationLogger.warnf("Use 'netstat -anv | grep %d' to identify the process occupying the port.", (Object)sslPort);
                            }
                            applicationLogger.warn("You can try to kill it with 'kill -9 <pid>'.");
                        } else {
                            applicationLogger.warnf("Use 'netstat -anop | grep %d' to identify the process occupying the port.", (Object)port);
                            if (sslPort != null) {
                                applicationLogger.warnf("Use 'netstat -anop | grep %d' to identify the process occupying the port.", (Object)sslPort);
                            }
                            applicationLogger.warn("You can try to kill it with 'kill -9 <pid>'.");
                        }
                    } else if (rootCause instanceof ConfigurationException) {
                        System.err.println(rootCause.getMessage());
                    } else {
                        applicationLogger.errorv(rootCause, "Failed to start application (with profile {0})", (Object)ProfileManager.getActiveProfile());
                        ApplicationLifecycleManager.ensureConsoleLogsDrained();
                    }
                }
                stateLock.lock();
                try {
                    shutdownRequested = true;
                    stateCond.signalAll();
                }
                finally {
                    stateLock.unlock();
                }
                application.stop();
                (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(1, e);
                return;
            }
            finally {
                try {
                    ShutdownHookThread sh = shutdownHookThread;
                    shutdownHookThread = null;
                    if (sh != null) {
                        Runtime.getRuntime().removeShutdownHook(sh);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        if (!alreadyStarted) {
            application.stop();
        }
        (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(ApplicationLifecycleManager.getExitCode(), null);
    }

    private static void ensureConsoleLogsDrained() {
        AsyncHandler asyncHandler = null;
        for (Handler handler : InitialConfigurator.DELAYED_HANDLER.getHandlers()) {
            if (handler instanceof AsyncHandler) {
                asyncHandler = (AsyncHandler)handler;
                Handler[] nestedHandlers = asyncHandler.getHandlers();
                boolean foundNestedConsoleHandler = false;
                for (Handler nestedHandler : nestedHandlers) {
                    if (!(nestedHandler instanceof ConsoleHandler)) continue;
                    foundNestedConsoleHandler = true;
                    break;
                }
                if (!foundNestedConsoleHandler) {
                    asyncHandler = null;
                }
            }
            if (asyncHandler != null) break;
        }
        if (asyncHandler != null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void longLivedPostBootCleanup() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof RunnerClassLoader) {
            RunnerClassLoader rcl = (RunnerClassLoader)cl;
            rcl.resetInternalCaches();
        }
    }

    private static void registerHooks(BiConsumer<Integer, Throwable> exitCodeHandler) {
        if (ImageInfo.inImageRuntimeCode() && System.getenv(DISABLE_SIGNAL_HANDLERS) == null) {
            ApplicationLifecycleManager.registerSignalHandlers(exitCodeHandler);
        }
        shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private static void registerSignalHandlers(final BiConsumer<Integer, Throwable> exitCodeHandler) {
        SignalHandler exitHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                exitCodeHandler.accept(signal.getNumber() + 128, null);
            }
        };
        SignalHandler diagnosticsHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                DiagnosticPrinter.printDiagnostics(System.out);
            }
        };
        ApplicationLifecycleManager.handleSignal("INT", exitHandler);
        ApplicationLifecycleManager.handleSignal("TERM", exitHandler);
        if (IS_WINDOWS) {
            ApplicationLifecycleManager.handleSignal("BREAK", diagnosticsHandler);
        } else {
            ApplicationLifecycleManager.handleSignal("HUP", exitHandler);
            ApplicationLifecycleManager.handleSignal("QUIT", diagnosticsHandler);
        }
    }

    public static Application getCurrentApplication() {
        return currentApplication;
    }

    public static int getExitCode() {
        return exitCode == -1 ? 0 : exitCode;
    }

    public static void exit() {
        ApplicationLifecycleManager.exit(-1);
    }

    public static BiConsumer<Integer, Throwable> getDefaultExitCodeHandler() {
        return defaultExitCodeHandler;
    }

    public static boolean isVmShuttingDown() {
        return vmShuttingDown;
    }

    public static void setDefaultExitCodeHandler(BiConsumer<Integer, Throwable> defaultExitCodeHandler) {
        Objects.requireNonNull(defaultExitCodeHandler);
        ApplicationLifecycleManager.defaultExitCodeHandler = defaultExitCodeHandler;
    }

    public static void setDefaultExitCodeHandler(Consumer<Integer> defaultExitCodeHandler) {
        ApplicationLifecycleManager.setDefaultExitCodeHandler((Integer exitCode, Throwable cause) -> defaultExitCodeHandler.accept((Integer)exitCode));
    }

    public static void exit(int code) {
        stateLock.lock();
        try {
            if (code >= 0 && exitCode == -1) {
                exitCode = code;
            }
            if (shutdownRequested) {
                return;
            }
            shutdownRequested = true;
            stateCond.signalAll();
        }
        finally {
            stateLock.unlock();
        }
    }

    public static void waitForExit() {
        stateLock.lock();
        try {
            while (!shutdownRequested) {
                stateCond.awaitUninterruptibly();
            }
        }
        finally {
            stateLock.unlock();
        }
    }

    private static void handleSignal(String signal, SignalHandler handler) {
        try {
            Signal.handle(new Signal(signal), handler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static {
        exitCode = -1;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        IS_MAC = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }

    static class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("Shutdown thread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            stateLock.lock();
            vmShuttingDown = true;
            shutdownRequested = true;
            try {
                stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            if (currentApplication.isStarted()) {
                currentApplication.stop();
            }
            currentApplication.awaitShutdown();
            System.out.flush();
            System.err.flush();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

