/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime.devmode;

import io.quarkus.smallrye.reactivemessaging.runtime.devmode.DevModeSupportConnectorFactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Interceptor
@DevModeSupportConnectorFactory
@Priority(value=10)
public class DevModeSupportConnectorFactoryInterceptor {
    private static volatile Supplier<CompletableFuture<Boolean>> onMessage;

    static void register(Supplier<CompletableFuture<Boolean>> onMessage) {
        DevModeSupportConnectorFactoryInterceptor.onMessage = onMessage;
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (onMessage == null) {
            return ctx.proceed();
        }
        if (ctx.getMethod().getName().equals("getPublisherBuilder")) {
            PublisherBuilder result2 = (PublisherBuilder)ctx.proceed();
            return result2.flatMapCompletionStage(msg -> {
                CompletableFuture future = new CompletableFuture();
                onMessage.get().whenComplete((restarted, error) -> {
                    if (!restarted.booleanValue()) {
                        future.complete(msg);
                    }
                });
                return future;
            });
        }
        if (ctx.getMethod().getName().equals("getSubscriberBuilder")) {
            final SubscriberBuilder result3 = (SubscriberBuilder)ctx.proceed();
            return ReactiveStreams.fromSubscriber(new Subscriber<Message<?>>(){
                private Subscriber<Message<?>> subscriber;

                @Override
                public void onSubscribe(Subscription s) {
                    this.subscriber = result3.build();
                    this.subscriber.onSubscribe(s);
                }

                @Override
                public void onNext(Message<?> o) {
                    this.subscriber.onNext(o);
                    onMessage.get();
                }

                @Override
                public void onError(Throwable t) {
                    this.subscriber.onError(t);
                    onMessage.get();
                }

                @Override
                public void onComplete() {
                    this.subscriber.onComplete();
                    onMessage.get();
                }
            });
        }
        return ctx.proceed();
    }
}

