/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.disposables;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.ProtocolViolationException;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public enum DisposableHelper implements Disposable
{
    DISPOSED;


    public static boolean isDisposed(Disposable d) {
        return d == DISPOSED;
    }

    public static boolean set(AtomicReference<Disposable> field2, Disposable d) {
        Disposable current;
        do {
            if ((current = field2.get()) != DISPOSED) continue;
            if (d != null) {
                d.dispose();
            }
            return false;
        } while (!field2.compareAndSet(current, d));
        if (current != null) {
            current.dispose();
        }
        return true;
    }

    public static boolean setOnce(AtomicReference<Disposable> field2, Disposable d) {
        Objects.requireNonNull(d, "d is null");
        if (!field2.compareAndSet(null, d)) {
            d.dispose();
            if (field2.get() != DISPOSED) {
                DisposableHelper.reportDisposableSet();
            }
            return false;
        }
        return true;
    }

    public static boolean replace(AtomicReference<Disposable> field2, Disposable d) {
        Disposable current;
        do {
            if ((current = field2.get()) != DISPOSED) continue;
            if (d != null) {
                d.dispose();
            }
            return false;
        } while (!field2.compareAndSet(current, d));
        return true;
    }

    public static boolean dispose(AtomicReference<Disposable> field2) {
        DisposableHelper d;
        Disposable current = field2.get();
        if (current != (d = DISPOSED) && (current = field2.getAndSet(d)) != d) {
            if (current != null) {
                current.dispose();
            }
            return true;
        }
        return false;
    }

    public static boolean validate(Disposable current, Disposable next) {
        if (next == null) {
            RxJavaPlugins.onError(new NullPointerException("next is null"));
            return false;
        }
        if (current != null) {
            next.dispose();
            DisposableHelper.reportDisposableSet();
            return false;
        }
        return true;
    }

    public static void reportDisposableSet() {
        RxJavaPlugins.onError(new ProtocolViolationException("Disposable already set!"));
    }

    public static boolean trySet(AtomicReference<Disposable> field2, Disposable d) {
        if (!field2.compareAndSet(null, d)) {
            if (field2.get() == DISPOSED) {
                d.dispose();
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return true;
    }
}

