/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.TypeHelper;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import java.io.PrintWriter;
import java.util.stream.Collectors;

public class MutinyMethodGenerator {
    protected final PrintWriter writer;

    public MutinyMethodGenerator(PrintWriter writer) {
        this.writer = writer;
    }

    public void generateJavadoc(MutinyMethodDescriptor descriptor) {
        MethodInfo original = descriptor.getOriginalMethod();
        MethodInfo method = descriptor.getMethod();
        Doc doc = original.getDoc();
        boolean deprecated2 = descriptor.isDeprecated();
        String link = CodeGenHelper.renderLinkToHtml(descriptor.getMethod().getOwnerTypes().iterator().next(), descriptor.getMethod());
        if (doc != null) {
            this.writer.println("  /**");
            if (descriptor.isUniMethod()) {
                Token.toHtml(doc.getTokens(), "   *", CodeGenHelper::renderLinkToHtml, "\n", this.writer);
                this.writer.println("   * <p>");
                this.writer.println("   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link " + Uni.class.getName() + " Uni}.");
                this.writer.println("   * Don't forget to <em>subscribe</em> on it to trigger the operation.");
            } else if (descriptor.isAwaitMethod()) {
                this.writer.println("   * Blocking variant of " + this.sanitize(link) + ".");
                this.writer.println("   * <p>");
                this.writer.println("   * This method waits for the completion of the underlying asynchronous operation.");
                this.writer.println("   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).");
            } else if (descriptor.isForgetMethod()) {
                this.writer.println("   * Variant of " + this.sanitize(link) + " that ignores the result of the operation.");
                this.writer.println("   * <p>");
                this.writer.println("   * This method subscribes on the result of " + this.sanitize(link) + ", but discards the outcome (item or failure).");
                this.writer.println("   * This method is useful to trigger the asynchronous operation from " + this.sanitize(link) + " but you don't need to compose it with other operations.");
            }
            for (ParamInfo param2 : method.getParams()) {
                this.writer.print("   * @param ");
                this.writer.print(param2.getName());
                this.writer.print(" ");
                if (param2.getDescription() != null) {
                    Token.toHtml(param2.getDescription().getTokens(), "", CodeGenHelper::renderLinkToHtml, "", this.writer);
                }
                this.writer.println();
            }
            if (!method.getReturnType().getName().equalsIgnoreCase("void")) {
                this.writer.print("   * @return ");
                if (method.getReturnDescription() != null && descriptor.isSimple()) {
                    Token.toHtml(method.getReturnDescription().getTokens(), "", CodeGenHelper::renderLinkToHtml, "", this.writer);
                } else if (descriptor.isUniMethod()) {
                    this.writer.print("the {@link " + Uni.class.getName() + " uni} firing the result of the operation when completed, or a failure if the operation failed.");
                } else if (descriptor.isAwaitMethod()) {
                    this.writer.print("the " + method.getReturnType().getSimpleName() + " instance produced by the operation.");
                } else if (descriptor.fluent) {
                    this.writer.print("the instance of " + method.getReturnType().getSimpleName() + " to chain method calls.");
                }
                this.writer.println();
            }
            if (deprecated2) {
                this.writer.print("   * @deprecated");
                if (original.getDeprecatedDesc() != null) {
                    this.writer.print(" " + original.getDeprecatedDesc().getValue());
                }
            }
            this.writer.println("   */");
        }
    }

    private String sanitize(String link) {
        return link.replace("AndAwait", "").replace("AndForget", "");
    }

    public void generateMethodDeclaration(MutinyMethodDescriptor descriptor) {
        MethodInfo method = descriptor.getMethod();
        if (descriptor.isDeprecated()) {
            this.writer.println("  @Deprecated");
        }
        if (descriptor.isFluent()) {
            this.writer.println("  @Fluent");
        }
        if (descriptor.isPrivate()) {
            this.writer.print("  private ");
        } else {
            this.writer.print("  public ");
        }
        if (method.isStaticMethod()) {
            this.writer.print("static ");
        }
        if (method.getTypeParams().size() > 0) {
            this.writer.print(method.getTypeParams().stream().map(TypeParamInfo::getName).collect(Collectors.joining(", ", "<", ">")));
            this.writer.print(" ");
        }
        if (descriptor.isForgetMethod() && !descriptor.fluent) {
            this.writer.print("void");
        } else if (descriptor.isAwaitMethod() && descriptor.getMethod().getReturnType().isVoid()) {
            this.writer.print("void");
        } else {
            this.writer.print(CodeGenHelper.genTranslatedTypeName(method.getReturnType()));
        }
        this.writer.print(" ");
        this.writer.print(method.getName());
        this.writer.print("(");
        this.writer.print(method.getParams().stream().map(it -> {
            if (TypeHelper.isHandlerOfPromise(it) || TypeHelper.isConsumerOfPromise(it)) {
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)it.getType();
                TypeInfo promise = type.getArg(0);
                TypeInfo inner = ((ParameterizedTypeInfo)promise).getArg(0);
                return Uni.class.getName() + "<" + CodeGenHelper.genTranslatedTypeName(inner) + "> " + it.getName();
            }
            return CodeGenHelper.genTranslatedTypeName(it.getType()) + " " + it.getName();
        }).collect(Collectors.joining(", ")));
        this.writer.print(")");
    }
}

