/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;

    public static ObjectNode objectNode() {
        return factory.objectNode();
    }

    public static ArrayNode arrayNode() {
        return factory.arrayNode();
    }

    private JsonUtil() {
    }

    public static String stringProperty(JsonNode node, String propertyName) {
        JsonNode propertyNode = node.get(propertyName);
        if (propertyNode != null) {
            return propertyNode.asText();
        }
        return null;
    }

    public static void stringProperty(ObjectNode node, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return;
        }
        node.set(propertyName, factory.textNode(propertyValue));
    }

    public static <E extends Enum<E>> void enumProperty(ObjectNode node, String propertyName, E propertyValue) {
        if (propertyValue == null) {
            return;
        }
        node.set(propertyName, factory.textNode(propertyValue.toString()));
    }

    public static Optional<Boolean> booleanProperty(JsonNode node, String propertyName) {
        JsonNode propertyNode = node.get(propertyName);
        if (propertyNode != null) {
            return Optional.of(propertyNode.asBoolean());
        }
        return Optional.empty();
    }

    public static void booleanProperty(ObjectNode node, String propertyName, Boolean propertyValue) {
        if (propertyValue == null) {
            return;
        }
        node.set(propertyName, factory.booleanNode(propertyValue));
    }

    public static Integer intProperty(JsonNode node, String propertyName) {
        JsonNode propertyNode = node.get(propertyName);
        if (propertyNode != null) {
            return propertyNode.asInt();
        }
        return null;
    }

    public static void intProperty(ObjectNode node, String propertyName, Integer propertyValue) {
        if (propertyValue == null) {
            return;
        }
        node.set(propertyName, factory.numberNode(propertyValue));
    }

    public static BigDecimal bigDecimalProperty(JsonNode node, String propertyName) {
        JsonNode propertyNode = node.get(propertyName);
        if (propertyNode != null) {
            return new BigDecimal(propertyNode.asText());
        }
        return null;
    }

    public static void bigDecimalProperty(ObjectNode node, String propertyName, BigDecimal propertyValue) {
        if (propertyValue == null) {
            return;
        }
        if (JsonUtil.isIntegerValue(propertyValue)) {
            node.set(propertyName, factory.numberNode(propertyValue.toBigInteger()));
        } else {
            node.set(propertyName, factory.numberNode(propertyValue));
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.signum() == 0 || bd.scale() <= 0 || bd.stripTrailingZeros().scale() <= 0;
    }

    public static Object readObject(JsonNode node) {
        if (node == null) {
            return null;
        }
        if (node.isBigDecimal()) {
            return new BigDecimal(node.asText());
        }
        if (node.isBigInteger()) {
            return new BigInteger(node.asText());
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isFloat()) {
            return node.asDouble();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isLong()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> items = new ArrayList<Object>();
            for (JsonNode itemNode : arrayNode) {
                items.add(JsonUtil.readObject(itemNode));
            }
            return items;
        }
        if (node.isObject()) {
            LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
            Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field2 = fields.next();
                String fieldName = field2.getKey();
                Object fieldValue = JsonUtil.readObject(field2.getValue());
                items.put(fieldName, fieldValue);
            }
            return items;
        }
        return null;
    }

    public static Object parseValue(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if ("true".equals(value = value.trim()) || "false".equals(value)) {
            return Boolean.valueOf(value);
        }
        switch (value.charAt(0)) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '[': 
            case '{': {
                try {
                    JsonNode node = MAPPER.readTree(value);
                    return JsonUtil.readObject(node);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        return value;
    }

    public static Optional<List<String>> readStringArray(JsonNode node) {
        if (node != null && node.isArray()) {
            ArrayList<String> rval = new ArrayList<String>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                if (arrayItem == null) continue;
                rval.add(arrayItem.asText());
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Optional<List<Object>> readObjectArray(JsonNode node) {
        if (node != null && node.isArray()) {
            ArrayList<Object> rval = new ArrayList<Object>(node.size());
            ArrayNode arrayNode = (ArrayNode)node;
            for (JsonNode arrayItem : arrayNode) {
                if (arrayItem == null) continue;
                rval.add(JsonUtil.readObject(arrayItem));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Optional<Map<String, String>> readStringMap(JsonNode node) {
        if (node != null && node.isObject()) {
            LinkedHashMap<String, String> rval = new LinkedHashMap<String, String>();
            Iterator<String> fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = fieldNames.next();
                String value = JsonUtil.stringProperty(node, fieldName);
                rval.put(fieldName, value);
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }
}

