/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.ScannerMessages;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

public class SchemaRegistry {
    private static final ThreadLocal<SchemaRegistry> current = new ThreadLocal();
    private final AnnotationScannerContext context;
    private final OpenApiConfig config;
    private final OpenAPI oai;
    private final IndexView index;
    private final Map<TypeKey, GeneratedSchemaInfo> registry = new LinkedHashMap<TypeKey, GeneratedSchemaInfo>();
    private final Set<String> names = new LinkedHashSet<String>();

    public static SchemaRegistry newInstance(AnnotationScannerContext context) {
        SchemaRegistry registry = new SchemaRegistry(context);
        current.set(registry);
        return registry;
    }

    public static SchemaRegistry currentInstance() {
        return current.get();
    }

    public static void remove() {
        current.remove();
    }

    public static Schema checkRegistration(Type type, TypeResolver resolver, Schema schema) {
        return SchemaRegistry.register(type, resolver, schema, (registry, key) -> registry.register((TypeKey)key, schema, null));
    }

    public static Schema registerReference(Type type, TypeResolver resolver, Schema schema) {
        return SchemaRegistry.register(type, resolver, schema, (registry, key) -> registry.registerReference((TypeKey)key));
    }

    static Schema register(Type type, TypeResolver resolver, Schema schema, BiFunction<SchemaRegistry, TypeKey, Schema> registrationAction) {
        Type resolvedType = resolver == null ? type : resolver.resolve(type);
        switch (resolvedType.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: 
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                break;
            }
            default: {
                return schema;
            }
        }
        SchemaRegistry registry = SchemaRegistry.currentInstance();
        if (registry == null) {
            return schema;
        }
        TypeKey key = new TypeKey(resolvedType);
        if (registry.hasRef(key)) {
            schema = registry.lookupRef(key);
        } else {
            if (!registry.isTypeRegistrationSupported(resolvedType, schema) || registry.index.getClassByName(resolvedType.name()) == null) {
                return schema;
            }
            schema = registrationAction.apply(registry, key);
        }
        return schema;
    }

    public static boolean hasSchema(Type type, TypeResolver resolver) {
        SchemaRegistry registry = SchemaRegistry.currentInstance();
        if (registry == null) {
            return false;
        }
        Type resolvedType = resolver != null ? resolver.resolve(type) : type;
        return registry.hasSchema(resolvedType);
    }

    private SchemaRegistry(AnnotationScannerContext context) {
        Map<String, Schema> schemas;
        this.context = context;
        this.config = context.getConfig();
        this.oai = context.getOpenApi();
        this.index = context.getAugmentedIndex();
        Components components = this.oai.getComponents();
        if (components != null && (schemas = components.getSchemas()) != null) {
            this.names.addAll(schemas.keySet());
        }
        this.config.getSchemas().entrySet().forEach(entry -> {
            Schema schema;
            String className = (String)entry.getKey();
            String jsonSchema = (String)entry.getValue();
            try {
                schema = OpenApiParser.parseSchema(jsonSchema);
            }
            catch (Exception e) {
                ScannerLogging.logger.errorParsingSchema(className);
                return;
            }
            Type type = Type.create(DotName.createSimple(className), Type.Kind.CLASS);
            this.register(new TypeKey(type), schema, ((SchemaImpl)schema).getName());
            ScannerLogging.logger.configSchemaRegistered(className);
        });
    }

    public Schema register(Type entityType, Schema schema) {
        TypeKey key = new TypeKey(entityType);
        if (this.hasRef(key)) {
            this.remove(key);
        }
        return this.register(key, schema, null);
    }

    private Schema registerReference(TypeKey key) {
        String name = this.deriveName(key, null);
        SchemaImpl schemaRef = new SchemaImpl();
        schemaRef.setRef("#/components/schemas/" + name);
        this.registry.put(key, new GeneratedSchemaInfo(name, null, schemaRef));
        this.names.add(name);
        return schemaRef;
    }

    private Schema register(TypeKey key, Schema schema, String schemaName) {
        String name = this.deriveName(key, schemaName);
        SchemaImpl schemaRef = new SchemaImpl();
        schemaRef.setRef("#/components/schemas/" + name);
        this.registry.put(key, new GeneratedSchemaInfo(name, schema, schemaRef));
        this.names.add(name);
        ModelUtil.components(this.oai).addSchema(name, schema);
        return schemaRef;
    }

    String deriveName(TypeKey key, String schemaName) {
        String nameBase;
        if (schemaName == null) {
            AnnotationInstance schemaAnnotation;
            ClassInfo targetSchema = this.index.getClassByName(key.type.name());
            AnnotationInstance annotationInstance = schemaAnnotation = targetSchema != null ? TypeUtil.getSchemaAnnotation((AnnotationTarget)targetSchema) : null;
            if (schemaAnnotation != null) {
                schemaName = JandexUtil.stringValue(schemaAnnotation, "name");
            }
        }
        String name = nameBase = schemaName != null ? schemaName : key.defaultName();
        int idx = 1;
        while (this.names.contains(name)) {
            name = nameBase + idx++;
        }
        return name;
    }

    public Schema lookupRef(Type instanceType) {
        return this.lookupRef(new TypeKey(instanceType));
    }

    public boolean hasRef(Type instanceType) {
        return this.hasRef(new TypeKey(instanceType));
    }

    public Schema lookupSchema(Type instanceType) {
        return this.lookupSchema(new TypeKey(instanceType));
    }

    public boolean hasSchema(Type instanceType) {
        return this.hasSchema(new TypeKey(instanceType));
    }

    public boolean isTypeRegistrationSupported(Type type, Schema schema) {
        if (this.config == null || !TypeUtil.allowRegistration(this.context, type)) {
            return false;
        }
        if (!this.config.arrayReferencesEnable()) {
            return !Schema.SchemaType.ARRAY.equals((Object)schema.getType());
        }
        return true;
    }

    private Schema lookupRef(TypeKey key) {
        GeneratedSchemaInfo info = this.registry.get(key);
        if (info == null) {
            throw ScannerMessages.msg.notRegistered(key.type.name());
        }
        return info.schemaRef;
    }

    private Schema lookupSchema(TypeKey key) {
        GeneratedSchemaInfo info = this.registry.get(key);
        if (info == null) {
            throw ScannerMessages.msg.notRegistered(key.type.name());
        }
        return info.schema;
    }

    private boolean hasRef(TypeKey key) {
        return this.registry.containsKey(key);
    }

    private boolean hasSchema(TypeKey key) {
        return this.registry.containsKey(key) && this.registry.get((Object)key).schema != null;
    }

    private void remove(TypeKey key) {
        GeneratedSchemaInfo info = this.registry.remove(key);
        this.names.remove(info.name);
    }

    static class TypeKey {
        private final Type type;
        private int hashCode = 0;

        TypeKey(Type type) {
            this.type = type;
        }

        public String defaultName() {
            StringBuilder name = new StringBuilder(this.type.name().local());
            switch (this.type.kind()) {
                case PARAMETERIZED_TYPE: {
                    TypeKey.appendParameterNames(name, this.type.asParameterizedType());
                    break;
                }
                case WILDCARD_TYPE: {
                    name.append(TypeKey.wildcardName(this.type.asWildcardType()));
                    break;
                }
            }
            return name.toString();
        }

        static void appendParameterNames(StringBuilder name, ParameterizedType type) {
            block4: for (Type param2 : type.asParameterizedType().arguments()) {
                switch (param2.kind()) {
                    case PARAMETERIZED_TYPE: {
                        name.append(param2.name().local());
                        TypeKey.appendParameterNames(name, param2.asParameterizedType());
                        continue block4;
                    }
                    case WILDCARD_TYPE: {
                        name.append(TypeKey.wildcardName(param2.asWildcardType()));
                        continue block4;
                    }
                }
                name.append(param2.name().local());
            }
        }

        static String wildcardName(WildcardType type) {
            Type superBound = type.superBound();
            if (superBound != null) {
                return "Super" + superBound.name().local();
            }
            Type extendsBound = type.extendsBound();
            if (!DotName.createSimple("java.lang.Object").equals(extendsBound.name())) {
                return "Extends" + extendsBound.name().local();
            }
            return extendsBound.name().local();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeKey other = (TypeKey)o;
            if (this.type == other.type) {
                return true;
            }
            if (this.type == null || this.type.getClass() != other.type.getClass()) {
                return false;
            }
            if (!this.type.name().equals(other.type.name())) {
                return false;
            }
            if (this.type instanceof ParameterizedType) {
                Type otherOwner;
                ParameterizedType paramType = (ParameterizedType)this.type;
                ParameterizedType otherType = (ParameterizedType)other.type;
                Type typeOwner = paramType.owner();
                return (typeOwner == (otherOwner = otherType.owner()) || typeOwner != null && typeOwner.equals(otherOwner)) && Objects.equals(paramType.arguments(), otherType.arguments());
            }
            if (this.type instanceof TypeVariable) {
                String otherId;
                TypeVariable varType = (TypeVariable)this.type;
                TypeVariable otherType = (TypeVariable)other.type;
                String id = varType.identifier();
                return id.equals(otherId = otherType.identifier()) && Objects.equals(varType.bounds(), otherType.bounds());
            }
            if (this.type instanceof WildcardType) {
                WildcardType wildType = (WildcardType)this.type;
                WildcardType otherType = (WildcardType)other.type;
                return Objects.equals(wildType.extendsBound(), otherType.extendsBound()) && Objects.equals(wildType.superBound(), otherType.superBound());
            }
            return true;
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash != 0) {
                return hash;
            }
            hash = this.type.name().hashCode();
            if (this.type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)this.type;
                Type owner = paramType.owner();
                hash = 31 * hash + Objects.hashCode(paramType.arguments());
                hash = 31 * hash + (owner != null ? owner.hashCode() : 0);
            }
            if (this.type instanceof TypeVariable) {
                TypeVariable varType = (TypeVariable)this.type;
                hash = 31 * hash + varType.identifier().hashCode();
                hash = 31 * hash + Objects.hashCode(varType.bounds());
            }
            if (this.type instanceof WildcardType) {
                WildcardType wildType = (WildcardType)this.type;
                hash = 31 * hash + Objects.hash(wildType.extendsBound(), wildType.superBound());
            }
            this.hashCode = hash;
            return hash;
        }
    }

    static class GeneratedSchemaInfo {
        public final String name;
        public final Schema schema;
        public final Schema schemaRef;

        GeneratedSchemaInfo(String name, Schema schema, Schema schemaRef) {
            this.name = name;
            this.schema = schema;
            this.schemaRef = schemaRef;
        }
    }
}

