/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectMessages;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class DataObjectDeque {
    private final Deque<PathEntry> path = new ArrayDeque<PathEntry>();
    private final AugmentedIndexView index;

    public DataObjectDeque(AugmentedIndexView index) {
        this.index = index;
    }

    public int size() {
        return this.path.size();
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public PathEntry peek() {
        return this.path.peek();
    }

    public void push(PathEntry entry) {
        this.path.push(entry);
    }

    public PathEntry pop() {
        return this.path.pop();
    }

    public void push(AnnotationTarget annotationTarget, PathEntry parentPathEntry, Type type, Schema schema) {
        DataObjectDeque.validateInput(parentPathEntry, type, schema);
        PathEntry entry = this.leafNode(parentPathEntry, annotationTarget, type, schema);
        ClassInfo klazzInfo = entry.getClazz();
        if (parentPathEntry.hasParent(entry)) {
            DataObjectLogging.logger.possibleCycle(klazzInfo);
            DataObjectLogging.logger.path(entry.toStringWithGraph());
            if (schema.getDescription() == null) {
                schema.description("Cyclic reference to " + klazzInfo.name());
            }
        } else {
            DataObjectLogging.logger.addingChildNode(klazzInfo);
            this.path.push(entry);
        }
    }

    public PathEntry rootNode(AnnotationTarget annotationTarget, ClassInfo classInfo, Type type, Schema rootSchema) {
        return new PathEntry(null, annotationTarget, classInfo, type, rootSchema);
    }

    public PathEntry leafNode(PathEntry parentNode, AnnotationTarget annotationTarget, Type classType, Schema schema) {
        ClassInfo classInfo = this.index.getClass(classType);
        return new PathEntry(parentNode, annotationTarget, classInfo, classType, schema);
    }

    private static void validateInput(Object ... input) {
        for (Object t : input) {
            if (t != null) continue;
            throw DataObjectMessages.msg.notNull();
        }
    }

    public static final class PathEntry {
        private final PathEntry enclosing;
        private final AnnotationTarget annotationTarget;
        private final Type clazzType;
        private final ClassInfo clazz;
        private Schema schema;

        private PathEntry(PathEntry enclosing, AnnotationTarget annotationTarget, ClassInfo clazz, Type clazzType, Schema schema) {
            DataObjectDeque.validateInput(new Object[]{clazz, clazzType, schema});
            this.enclosing = enclosing;
            this.annotationTarget = annotationTarget;
            this.clazz = clazz;
            this.clazzType = clazzType;
            this.schema = schema;
        }

        public boolean hasParent(PathEntry candidate) {
            PathEntry test = this;
            while (test != null) {
                if (candidate.equals(test)) {
                    return true;
                }
                test = test.enclosing;
            }
            return false;
        }

        public AnnotationTarget getAnnotationTarget() {
            return this.annotationTarget;
        }

        public PathEntry getEnclosing() {
            return this.enclosing;
        }

        public Type getClazzType() {
            return this.clazzType;
        }

        public ClassInfo getClazz() {
            return this.clazz;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            boolean result2;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathEntry otherEntry = (PathEntry)o;
            boolean bl = this.clazz != null ? this.clazz.equals(otherEntry.clazz) : (result2 = otherEntry.clazz == null);
            if (this.clazzType.kind() == Type.Kind.PARAMETERIZED_TYPE && otherEntry.clazzType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                return result2 && this.argsEqual(otherEntry);
            }
            return result2;
        }

        private boolean argsEqual(PathEntry otherPair) {
            ParameterizedType thisClazzPType = this.clazzType.asParameterizedType();
            ParameterizedType otherClazzPType = otherPair.clazzType.asParameterizedType();
            List<Type> thisArgs = thisClazzPType.arguments();
            List<Type> otherArgs = otherClazzPType.arguments();
            return thisArgs.equals(otherArgs);
        }

        public int hashCode() {
            return this.clazz != null ? this.clazz.hashCode() : 0;
        }

        public String toString() {
            return "PathEntry{clazz=" + this.clazz + ", schema=" + this.schema + '}';
        }

        public String toStringWithGraph() {
            return "PathEntry{clazz=" + this.clazz + ", schema=" + this.schema + ", parent=" + (this.enclosing != null ? this.enclosing.toStringWithGraph() : "<root>") + "}";
        }
    }
}

