/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.tracing;

import io.opentelemetry.context.propagation.TextMapGetter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class HeaderExtractAdapter
implements TextMapGetter<Headers> {
    public static final HeaderExtractAdapter GETTER = new HeaderExtractAdapter();
    private Iterable<String> keys;

    @Override
    public Iterable<String> keys(Headers headers) {
        if (this.keys == null) {
            this.keys = Arrays.stream(headers.toArray()).map(Header::key).collect(Collectors.toList());
        }
        return this.keys;
    }

    @Override
    public String get(Headers headers, String key) {
        if (headers == null) {
            return null;
        }
        Header header = headers.lastHeader(key);
        if (header == null) {
            return null;
        }
        return new String(header.value(), StandardCharsets.UTF_8);
    }
}

