/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.AsynchronousCounter;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.core.shareddata.impl.LocalAsyncLocks;
import io.vertx.core.shareddata.impl.LocalAsyncMapImpl;
import io.vertx.core.shareddata.impl.LocalMapImpl;
import io.vertx.core.spi.cluster.ClusterManager;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedDataImpl
implements SharedData {
    private static final long DEFAULT_LOCK_TIMEOUT = 10000L;
    private final VertxInternal vertx;
    private final ClusterManager clusterManager;
    private final LocalAsyncLocks localAsyncLocks;
    private final ConcurrentMap<String, LocalAsyncMapImpl<?, ?>> localAsyncMaps = new ConcurrentHashMap();
    private final ConcurrentMap<String, Counter> localCounters = new ConcurrentHashMap<String, Counter>();
    private final ConcurrentMap<String, LocalMap<?, ?>> localMaps = new ConcurrentHashMap();

    public SharedDataImpl(VertxInternal vertx, ClusterManager clusterManager) {
        this.vertx = vertx;
        this.clusterManager = clusterManager;
        this.localAsyncLocks = new LocalAsyncLocks();
    }

    @Override
    public <K, V> void getClusterWideMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getClusterWideMap(name).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getClusterWideMap(String name) {
        Objects.requireNonNull(name, "name");
        if (this.clusterManager == null) {
            throw new IllegalStateException("Can't get cluster wide map if not clustered");
        }
        PromiseInternal promise = this.vertx.promise();
        this.clusterManager.getAsyncMap(name, promise);
        return promise.future().map(WrappedAsyncMap::new);
    }

    @Override
    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAsyncMap(name).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getAsyncMap(String name) {
        Objects.requireNonNull(name, "name");
        if (this.clusterManager == null) {
            return this.getLocalAsyncMap(name);
        }
        PromiseInternal promise = this.vertx.promise();
        this.clusterManager.getAsyncMap(name, promise);
        return promise.future().map(WrappedAsyncMap::new);
    }

    @Override
    public void getLock(String name, Handler<AsyncResult<Lock>> resultHandler) {
        this.getLockWithTimeout(name, 10000L, resultHandler);
    }

    @Override
    public Future<Lock> getLock(String name) {
        return this.getLockWithTimeout(name, 10000L);
    }

    @Override
    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLockWithTimeout(name, timeout).onComplete(resultHandler);
    }

    @Override
    public Future<Lock> getLockWithTimeout(String name, long timeout) {
        Objects.requireNonNull(name, "name");
        Arguments.require(timeout >= 0L, "timeout must be >= 0");
        if (this.clusterManager == null) {
            return this.getLocalLockWithTimeout(name, timeout);
        }
        PromiseInternal<Lock> promise = this.vertx.promise();
        this.clusterManager.getLockWithTimeout(name, timeout, promise);
        return promise.future();
    }

    @Override
    public void getLocalLock(String name, Handler<AsyncResult<Lock>> resultHandler) {
        this.getLocalLockWithTimeout(name, 10000L, resultHandler);
    }

    @Override
    public Future<Lock> getLocalLock(String name) {
        return this.getLocalLockWithTimeout(name, 10000L);
    }

    @Override
    public void getLocalLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalLockWithTimeout(name, timeout).onComplete(resultHandler);
    }

    @Override
    public Future<Lock> getLocalLockWithTimeout(String name, long timeout) {
        Objects.requireNonNull(name, "name");
        Arguments.require(timeout >= 0L, "timeout must be >= 0");
        return this.localAsyncLocks.acquire(this.vertx.getOrCreateContext(), name, timeout);
    }

    @Override
    public Future<Counter> getCounter(String name) {
        Objects.requireNonNull(name, "name");
        if (this.clusterManager == null) {
            return this.getLocalCounter(name);
        }
        PromiseInternal<Counter> promise = this.vertx.promise();
        this.clusterManager.getCounter(name, promise);
        return promise.future();
    }

    @Override
    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getCounter(name).onComplete(resultHandler);
    }

    @Override
    public <K, V> LocalMap<K, V> getLocalMap(String name) {
        return this.localMaps.computeIfAbsent(name, n -> new LocalMapImpl((String)n, this.localMaps));
    }

    @Override
    public <K, V> void getLocalAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalAsyncMap(name).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getLocalAsyncMap(String name) {
        LocalAsyncMapImpl asyncMap = this.localAsyncMaps.computeIfAbsent(name, n -> new LocalAsyncMapImpl(this.vertx));
        ContextInternal context = this.vertx.getOrCreateContext();
        return context.succeededFuture(new WrappedAsyncMap(asyncMap));
    }

    @Override
    public void getLocalCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalCounter(name).onComplete(resultHandler);
    }

    @Override
    public Future<Counter> getLocalCounter(String name) {
        Counter counter2 = this.localCounters.computeIfAbsent(name, n -> new AsynchronousCounter(this.vertx));
        ContextInternal context = this.vertx.getOrCreateContext();
        return context.succeededFuture(counter2);
    }

    private static void checkType(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot put null in key or value of async map");
        }
        Class<?> clazz = obj.getClass();
        if (clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Boolean.class || clazz == Boolean.TYPE || clazz == Byte.class || clazz == Byte.TYPE || clazz == String.class || clazz == byte[].class) {
            return;
        }
        if (obj instanceof ClusterSerializable) {
            return;
        }
        if (obj instanceof Serializable) {
            return;
        }
        throw new IllegalArgumentException("Invalid type: " + clazz + " to put in async map");
    }

    public static final class WrappedAsyncMap<K, V>
    implements AsyncMap<K, V> {
        private final AsyncMap<K, V> delegate;

        WrappedAsyncMap(AsyncMap<K, V> other) {
            this.delegate = other;
        }

        @Override
        public Future<V> get(K k) {
            SharedDataImpl.checkType(k);
            return this.delegate.get(k);
        }

        @Override
        public Future<Void> put(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.put(k, v);
        }

        @Override
        public Future<Void> put(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.put(k, v, ttl);
        }

        @Override
        public Future<V> putIfAbsent(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.putIfAbsent(k, v);
        }

        @Override
        public Future<V> putIfAbsent(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.putIfAbsent(k, v, ttl);
        }

        @Override
        public Future<V> remove(K k) {
            SharedDataImpl.checkType(k);
            return this.delegate.remove(k);
        }

        @Override
        public Future<Boolean> removeIfPresent(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.removeIfPresent(k, v);
        }

        @Override
        public Future<V> replace(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.replace(k, v);
        }

        @Override
        public Future<V> replace(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.replace(k, v, ttl);
        }

        @Override
        public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(oldValue);
            SharedDataImpl.checkType(newValue);
            return this.delegate.replaceIfPresent(k, oldValue, newValue);
        }

        @Override
        public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(oldValue);
            SharedDataImpl.checkType(newValue);
            return this.delegate.replaceIfPresent(k, oldValue, newValue, ttl);
        }

        @Override
        public Future<Void> clear() {
            return this.delegate.clear();
        }

        @Override
        public Future<Integer> size() {
            return this.delegate.size();
        }

        @Override
        public Future<Set<K>> keys() {
            return this.delegate.keys();
        }

        @Override
        public Future<List<V>> values() {
            return this.delegate.values();
        }

        @Override
        public Future<Map<K, V>> entries() {
            return this.delegate.entries();
        }

        public AsyncMap<K, V> getDelegate() {
            return this.delegate;
        }
    }
}

