/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.WebSocketBase;
import io.vertx.mutiny.core.http.WebSocketFrame;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket
implements WebSocketBase {
    public static final TypeArg<ServerWebSocket> __TYPE_ARG = new TypeArg<ServerWebSocket>(obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket)obj), ServerWebSocket::getDelegate);
    private final io.vertx.core.http.ServerWebSocket delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
        this.delegate = delegate;
    }

    public ServerWebSocket(Object delegate) {
        this.delegate = (io.vertx.core.http.ServerWebSocket)delegate;
    }

    ServerWebSocket() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.http.ServerWebSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerWebSocket that = (ServerWebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writePing(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writePing(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writePingAndAwait(Buffer data) {
        return this.writePing(data).await().indefinitely();
    }

    @Override
    @Fluent
    public WebSocketBase writePingAndForget(Buffer data) {
        this.writePing(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writePong(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writePong(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writePongAndAwait(Buffer data) {
        return this.writePong(data).await().indefinitely();
    }

    @Override
    @Fluent
    public WebSocketBase writePongAndForget(Buffer data) {
        this.writePong(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private WebSocketBase __textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocketBase textMessageHandler(Consumer<String> handler) {
        return this.__textMessageHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private WebSocketBase __binaryMessageHandler(final Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase binaryMessageHandler(Consumer<Buffer> handler) {
        return this.__binaryMessageHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private WebSocketBase __pongHandler(final Handler<Buffer> handler) {
        this.delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public WebSocketBase pongHandler(Consumer<Buffer> handler) {
        return this.__pongHandler(handler != null ? handler::accept : null);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    @Override
    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close(short statusCode) {
        return AsyncResultUni.toUni(handler -> this.delegate.close(statusCode, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode) {
        return this.close(statusCode).await().indefinitely();
    }

    @Override
    public void closeAndForget(short statusCode) {
        this.close(statusCode).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close(short statusCode, String reason) {
        return AsyncResultUni.toUni(handler -> this.delegate.close(statusCode, reason, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait(short statusCode, String reason) {
        return this.close(statusCode, reason).await().indefinitely();
    }

    @Override
    public void closeAndForget(short statusCode, String reason) {
        this.close(statusCode, reason).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Fluent
    private ServerWebSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private ServerWebSocket __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public ServerWebSocket handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Override
    @Fluent
    public ServerWebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    @Fluent
    public ServerWebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    @Fluent
    public ServerWebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private ServerWebSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public ServerWebSocket endHandler(Runnable endHandler) {
        return this.__endHandler(ignored -> endHandler.run());
    }

    @Override
    @Fluent
    public ServerWebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private ServerWebSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket drainHandler(Runnable handler) {
        return this.__drainHandler(ignored -> handler.run());
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFrame(WebSocketFrame frame) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFrame(frame.getDelegate(), (Handler)handler));
    }

    @Override
    public Void writeFrameAndAwait(WebSocketFrame frame) {
        return this.writeFrame(frame).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFrameAndForget(WebSocketFrame frame) {
        this.writeFrame(frame).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFinalTextFrame(String text) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFinalTextFrame(text, (Handler)handler));
    }

    @Override
    public Void writeFinalTextFrameAndAwait(String text) {
        return this.writeFinalTextFrame(text).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFinalTextFrameAndForget(String text) {
        this.writeFinalTextFrame(text).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeFinalBinaryFrame(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeFinalBinaryFrame(data.getDelegate(), (Handler)handler));
    }

    @Override
    public Void writeFinalBinaryFrameAndAwait(Buffer data) {
        return this.writeFinalBinaryFrame(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeFinalBinaryFrameAndForget(Buffer data) {
        this.writeFinalBinaryFrame(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeBinaryMessage(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeBinaryMessage(data.getDelegate(), (Handler)handler));
    }

    @Override
    public Void writeBinaryMessageAndAwait(Buffer data) {
        return this.writeBinaryMessage(data).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeBinaryMessageAndForget(Buffer data) {
        this.writeBinaryMessage(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> writeTextMessage(String text) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeTextMessage(text, (Handler)handler));
    }

    @Override
    public Void writeTextMessageAndAwait(String text) {
        return this.writeTextMessage(text).await().indefinitely();
    }

    @Override
    @Fluent
    public ServerWebSocket writeTextMessageAndForget(String text) {
        this.writeTextMessage(text).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private ServerWebSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler((Handler)handler);
        return this;
    }

    @Override
    public ServerWebSocket closeHandler(Runnable handler) {
        return this.__closeHandler(ignored -> handler.run());
    }

    @Fluent
    private ServerWebSocket __frameHandler(final Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler((Handler)new Handler<io.vertx.core.http.WebSocketFrame>(){

            @Override
            public void handle(io.vertx.core.http.WebSocketFrame event) {
                handler.handle(WebSocketFrame.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public ServerWebSocket frameHandler(Consumer<WebSocketFrame> handler) {
        return this.__frameHandler(handler != null ? handler::accept : null);
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public void accept() {
        this.delegate.accept();
    }

    public void reject() {
        this.delegate.reject();
    }

    public void reject(int status) {
        this.delegate.reject(status);
    }

    @CheckReturnValue
    public Uni<Integer> setHandshake(Uni<Integer> future) {
        return AsyncResultUni.toUni(handler -> this.delegate.setHandshake(UniHelper.toFuture(future), (Handler<AsyncResult<Integer>>)handler));
    }

    public Integer setHandshakeAndAwait(Uni<Integer> future) {
        return this.setHandshake(future).await().indefinitely();
    }

    public void setHandshakeAndForget(Uni<Integer> future) {
        this.setHandshake(future).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
        return arg != null ? new ServerWebSocket(arg) : null;
    }
}

