/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;

public class FileKeyPairProvider
extends AbstractResourceKeyPairProvider<Path> {
    private Collection<? extends Path> files;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(Path path) {
        this(Collections.singletonList(Objects.requireNonNull(path, "No path provided")));
    }

    public FileKeyPairProvider(Path ... files2) {
        this(Arrays.asList(files2));
    }

    public FileKeyPairProvider(Collection<? extends Path> files2) {
        this.files = files2;
    }

    public Collection<? extends Path> getPaths() {
        return this.files;
    }

    public void setPaths(Collection<? extends Path> paths) {
        List<Path> resolved = GenericUtils.map(paths, Path::toAbsolutePath);
        this.resetCacheMap(resolved);
        this.files = resolved;
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return this.loadKeys(session, this.getPaths());
    }

    @Override
    protected IoResource<Path> getIoResource(SessionContext session, Path resource) {
        return resource == null ? null : new PathResource(resource);
    }

    @Override
    protected Iterable<KeyPair> doLoadKeys(SessionContext session, Path resource) throws IOException, GeneralSecurityException {
        return super.doLoadKeys(session, resource == null ? null : resource.toAbsolutePath());
    }
}

