/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class AddListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;
    private Channel channel;

    public AddListenerOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, byte[] listenerId, SocketAddress server) {
        super((short)90, (short)91, codec, channelFactory, topologyId, cfg, counterName, false);
        this.listenerId = listenerId;
        this.server = server;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.channel = channel;
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, ByteBufUtil.estimateArraySize(this.listenerId));
        ByteBufUtil.writeArray(buf, this.listenerId);
        channel.writeAndFlush(buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        if (status != 0) {
            this.complete(false);
        } else {
            decoder.addListener(this.listenerId);
            this.complete(true);
        }
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.server == null) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.channelFactory.fetchChannelAndInvoke(this.server, this);
        }
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.codec.allowOperationsAndEvents()) {
            super.releaseChannel(channel);
        }
    }

    public void cleanup() {
        this.channel.eventLoop().execute(() -> {
            HeaderDecoder decoder;
            if (log.isTraceEnabled()) {
                log.tracef("Cleanup for %s on %s", (Object)this, (Object)this.channel);
            }
            if (!this.codec.allowOperationsAndEvents() && this.channel.isOpen()) {
                super.releaseChannel(this.channel);
            }
            if ((decoder = this.channel.pipeline().get(HeaderDecoder.class)) != null) {
                decoder.removeListener(this.listenerId);
            }
        });
    }
}

