/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.logging.Log;

public class AttributeSet
implements AttributeListener<Object>,
Matchable<AttributeSet> {
    private final Class<?> klass;
    private final String name;
    private final Map<String, Attribute<?>> attributes;
    private boolean protect;

    public AttributeSet(Class<?> klass, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass, klass.getSimpleName(), null, attributeDefinitions);
    }

    public AttributeSet(String name, AttributeDefinition<?> ... attributeDefinitions) {
        this(name, (AttributeSet)null, attributeDefinitions);
    }

    public AttributeSet(Class<?> klass, AttributeSet attributeSet, AttributeDefinition<?> ... attributeDefinitions) {
        this(klass, klass.getSimpleName(), attributeSet, attributeDefinitions);
    }

    public AttributeSet(String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions) {
        this(null, name, attributeSet, attributeDefinitions);
    }

    private AttributeSet(Class<?> klass, String name, AttributeSet attributeSet, AttributeDefinition<?>[] attributeDefinitions) {
        this.klass = klass;
        this.name = name;
        if (attributeSet != null) {
            this.attributes = new LinkedHashMap(attributeDefinitions.length + attributeSet.attributes.size());
            for (Attribute attribute : attributeSet.attributes.values()) {
                this.attributes.put(attribute.name(), attribute.getAttributeDefinition().toAttribute());
            }
        } else {
            this.attributes = new LinkedHashMap(attributeDefinitions.length);
        }
        for (AttributeDefinition<?> def : attributeDefinitions) {
            if (this.attributes.containsKey(def.name())) {
                throw Log.CONFIG.attributeSetDuplicateAttribute(def.name(), name);
            }
            Attribute<Object> attribute = def.toAttribute();
            if (!attribute.isImmutable()) {
                attribute.addListener(this);
            }
            this.attributes.put(def.name(), attribute);
        }
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(String name) {
        return this.attributes.containsKey(name);
    }

    public <T> boolean contains(AttributeDefinition<T> def) {
        return this.contains(def.name());
    }

    public <T> Attribute<T> attribute(String name) {
        return this.attributes.get(name);
    }

    public <T> Attribute<T> attribute(AttributeDefinition<T> def) {
        Attribute<T> attribute = this.attribute(def.name());
        if (attribute != null) {
            return attribute;
        }
        throw Log.CONFIG.noSuchAttribute(def.name(), this.name);
    }

    public void read(AttributeSet other) {
        for (Attribute<?> attribute : this.attributes.values()) {
            Attribute a = other.attribute(attribute.name());
            if (!a.isModified()) continue;
            attribute.read(a);
        }
    }

    public AttributeSet protect() {
        AttributeDefinition[] attrDefs = new AttributeDefinition[this.attributes.size()];
        int i = 0;
        for (Attribute<?> attribute : this.attributes.values()) {
            attrDefs[i++] = attribute.getAttributeDefinition();
        }
        AttributeSet protectedSet = new AttributeSet(this.klass, this.name, null, attrDefs);
        for (Attribute<?> attribute : protectedSet.attributes.values()) {
            Attribute<?> localAttr = this.attributes.get(attribute.name());
            attribute.read(localAttr);
            attribute.protect();
        }
        protectedSet.protect = true;
        return protectedSet;
    }

    public boolean isModified() {
        for (Attribute<?> attribute : this.attributes.values()) {
            if (!attribute.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def) {
        this.write(writer, def, def.xmlName());
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def, Enum<?> name) {
        this.write(writer, def, name.toString());
    }

    public void write(ConfigurationWriter writer, AttributeDefinition<?> def, String name) {
        Attribute<?> attribute = this.attribute(def);
        attribute.write(writer, name);
    }

    public void write(ConfigurationWriter writer, String xmlElementName) {
        if (this.isModified()) {
            writer.writeStartElement(xmlElementName);
            this.write(writer);
            writer.writeEndElement();
        }
    }

    public void write(ConfigurationWriter writer, String xmlElementName, AttributeDefinition<?> ... defs) {
        boolean skip = true;
        for (AttributeDefinition<?> def : defs) {
            skip = skip && !this.attribute(def).isModified();
        }
        if (!skip) {
            writer.writeStartElement(xmlElementName);
            for (AttributeDefinition<?> def : defs) {
                Attribute<?> attr = this.attribute(def);
                attr.write(writer, attr.getAttributeDefinition().xmlName());
            }
            writer.writeEndElement();
        }
    }

    public void write(ConfigurationWriter writer) {
        for (Attribute<?> attr : this.attributes.values()) {
            if (!attr.isPersistent()) continue;
            attr.write(writer, attr.getAttributeDefinition().xmlName());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeSet other = (AttributeSet)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
    }

    @Override
    public boolean matches(AttributeSet other) {
        if (other.attributes.size() != this.attributes.size()) {
            return false;
        }
        for (Map.Entry<String, Attribute<?>> e : this.attributes.entrySet()) {
            String key = e.getKey();
            Attribute<?> value = e.getValue();
            if (!(value == null ? !other.attributes.containsKey(key) || other.attributes.get(key) != null : !value.matches(other.attributes.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(this.name);
    }

    public String toString(String name) {
        StringBuilder sb = new StringBuilder();
        if (name != null) {
            sb.append(name);
            sb.append(" = ");
        }
        sb.append("[");
        boolean comma = false;
        for (Attribute<?> value : this.attributes.values()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public AttributeSet checkProtection() {
        if (!this.protect) {
            throw Log.CONFIG.unprotectedAttributeSet(this.name);
        }
        return this;
    }

    public void reset() {
        if (this.protect) {
            throw Log.CONFIG.protectedAttributeSet(this.name);
        }
        for (Attribute<?> attribute : this.attributes.values()) {
            attribute.reset();
        }
    }

    @Override
    public void attributeChanged(Attribute<Object> attribute, Object oldValue) {
    }

    public Collection<Attribute<?>> attributes() {
        return this.attributes.values();
    }

    public boolean isEmpty() {
        return this.attributes.entrySet().stream().allMatch(attrs -> {
            Attribute attr = (Attribute)attrs.getValue();
            return attr.isNull() || !attr.isModified();
        });
    }
}

