/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor.types;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.types.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XEnumConstant;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;

public final class MirrorTypeFactory
implements XTypeFactory {
    private static final XClass[] EMPTY_XCLASS_ARRAY = new XClass[0];
    private final Elements elements;
    private final Types types;
    private final Map<String, XClass> classCache = new HashMap<String, XClass>();
    private final MirrorPrimitiveType voidType;
    private final MirrorPrimitiveType booleanType;
    private final MirrorPrimitiveType byteType;
    private final MirrorPrimitiveType shortType;
    private final MirrorPrimitiveType intType;
    private final MirrorPrimitiveType longType;
    private final MirrorPrimitiveType charType;
    private final MirrorPrimitiveType floatType;
    private final MirrorPrimitiveType doubleType;

    public MirrorTypeFactory(ProcessingEnvironment processingEnv) {
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.voidType = new MirrorPrimitiveType(Void.TYPE, this.types.getNoType(TypeKind.VOID));
        this.booleanType = new MirrorPrimitiveType(Boolean.TYPE, this.types.getPrimitiveType(TypeKind.BOOLEAN));
        this.byteType = new MirrorPrimitiveType(Byte.TYPE, this.types.getPrimitiveType(TypeKind.BYTE));
        this.shortType = new MirrorPrimitiveType(Short.TYPE, this.types.getPrimitiveType(TypeKind.SHORT));
        this.intType = new MirrorPrimitiveType(Integer.TYPE, this.types.getPrimitiveType(TypeKind.INT));
        this.longType = new MirrorPrimitiveType(Long.TYPE, this.types.getPrimitiveType(TypeKind.LONG));
        this.charType = new MirrorPrimitiveType(Character.TYPE, this.types.getPrimitiveType(TypeKind.CHAR));
        this.floatType = new MirrorPrimitiveType(Float.TYPE, this.types.getPrimitiveType(TypeKind.FLOAT));
        this.doubleType = new MirrorPrimitiveType(Double.TYPE, this.types.getPrimitiveType(TypeKind.DOUBLE));
    }

    @Override
    public XClass fromClass(Class<?> c) {
        TypeElement typeElement;
        if (c == null) {
            return null;
        }
        if (c == byte[].class) {
            MirrorPrimitiveType componentType = this.byteType;
            String fqn = "[" + componentType.getName();
            XClass xclass = this.classCache.get(fqn);
            if (xclass == null) {
                xclass = new MirrorArray(componentType);
                this.classCache.put(fqn, xclass);
            }
            return xclass;
        }
        if (c == Void.TYPE) {
            return this.voidType;
        }
        if (c == Boolean.TYPE) {
            return this.booleanType;
        }
        if (c == Byte.TYPE) {
            return this.byteType;
        }
        if (c == Short.TYPE) {
            return this.shortType;
        }
        if (c == Integer.TYPE) {
            return this.intType;
        }
        if (c == Long.TYPE) {
            return this.longType;
        }
        if (c == Character.TYPE) {
            return this.charType;
        }
        if (c == Float.TYPE) {
            return this.floatType;
        }
        if (c == Double.TYPE) {
            return this.doubleType;
        }
        String typeName = c.getCanonicalName();
        if (typeName == null) {
            typeName = c.getName();
        }
        if ((typeElement = this.elements.getTypeElement(typeName)) == null) {
            throw new IllegalStateException("Type not found : " + typeName);
        }
        return this.fromTypeMirror(typeElement.asType());
    }

    public XClass fromTypeMirror(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        switch (typeMirror.getKind()) {
            case ERROR: {
                throw new IllegalStateException("Unresolved type : " + typeMirror.toString());
            }
            case VOID: {
                return this.voidType;
            }
            case BOOLEAN: {
                return this.booleanType;
            }
            case BYTE: {
                return this.byteType;
            }
            case SHORT: {
                return this.shortType;
            }
            case INT: {
                return this.intType;
            }
            case LONG: {
                return this.longType;
            }
            case CHAR: {
                return this.charType;
            }
            case FLOAT: {
                return this.floatType;
            }
            case DOUBLE: {
                return this.doubleType;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                String fqn = ((TypeElement)declaredType.asElement()).getQualifiedName().toString();
                XClass xclass = this.classCache.get(fqn);
                if (xclass == null) {
                    xclass = new MirrorClass(declaredType);
                    this.classCache.put(fqn, xclass);
                }
                return xclass;
            }
            case ARRAY: {
                XClass componentType = this.fromTypeMirror(((ArrayType)typeMirror).getComponentType());
                String fqn = "[" + componentType.getName();
                XClass xclass = this.classCache.get(fqn);
                if (xclass == null) {
                    xclass = new MirrorArray(componentType);
                    this.classCache.put(fqn, xclass);
                }
                return xclass;
            }
        }
        throw new IllegalStateException("Unexpected type kind : " + (Object)((Object)typeMirror.getKind()));
    }

    private static int getModifiersOfElement(Element element) {
        int modifiers = 0;
        for (Modifier mod : element.getModifiers()) {
            switch (mod) {
                case DEFAULT: {
                    break;
                }
                case PUBLIC: {
                    modifiers |= 1;
                    break;
                }
                case PROTECTED: {
                    modifiers |= 4;
                    break;
                }
                case PRIVATE: {
                    modifiers |= 2;
                    break;
                }
                case ABSTRACT: {
                    modifiers |= 0x400;
                    break;
                }
                case STATIC: {
                    modifiers |= 8;
                    break;
                }
                case FINAL: {
                    modifiers |= 0x10;
                    break;
                }
                case TRANSIENT: {
                    modifiers |= 0x80;
                    break;
                }
                case VOLATILE: {
                    modifiers |= 0x40;
                    break;
                }
                case SYNCHRONIZED: {
                    modifiers |= 0x20;
                    break;
                }
                case NATIVE: {
                    modifiers |= 0x100;
                    break;
                }
                case STRICTFP: {
                    modifiers |= 0x800;
                }
            }
        }
        return modifiers;
    }

    private TypeMirror getTypeMirror(String typeName) {
        if ("void".equals(typeName)) {
            return this.types.getNoType(TypeKind.VOID);
        }
        if ("boolean".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.BOOLEAN);
        }
        if ("char".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.CHAR);
        }
        if ("byte".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.BYTE);
        }
        if ("short".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.SHORT);
        }
        if ("int".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.INT);
        }
        if ("long".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.LONG);
        }
        if ("float".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.FLOAT);
        }
        if ("double".equals(typeName)) {
            return this.types.getPrimitiveType(TypeKind.DOUBLE);
        }
        TypeElement typeElement = this.elements.getTypeElement(typeName);
        if (typeElement == null) {
            throw new IllegalStateException("Type not found : " + typeName);
        }
        return typeElement.asType();
    }

    private final class MirrorField
    implements XField {
        private final MirrorClass c;
        private final VariableElement field;
        private final XEnumConstant enumConstant;
        private final int modifiers;

        MirrorField(MirrorClass c, VariableElement field2, XEnumConstant enumConstant) {
            this.c = c;
            this.field = field2;
            this.enumConstant = enumConstant;
            this.modifiers = MirrorTypeFactory.getModifiersOfElement(field2);
        }

        @Override
        public XClass getType() {
            return MirrorTypeFactory.this.fromTypeMirror(this.field.asType());
        }

        @Override
        public XClass determineRepeatedElementType() {
            List<? extends TypeMirror> typeArguments;
            if (this.getType().isArray()) {
                return this.getType().getComponentType();
            }
            if (this.getType().isAssignableTo(Collection.class) && (typeArguments = ((DeclaredType)this.field.asType()).getTypeArguments()).size() == 1) {
                TypeMirror arg = typeArguments.get(0);
                return MirrorTypeFactory.this.fromTypeMirror(arg);
            }
            throw new IllegalStateException("Not a repeatable field");
        }

        @Override
        public boolean isEnumConstant() {
            return this.enumConstant != null;
        }

        @Override
        public XEnumConstant asEnumConstant() {
            if (this.enumConstant != null) {
                return this.enumConstant;
            }
            throw new IllegalStateException(this.getName() + " is not an enum constant");
        }

        @Override
        public String getName() {
            return this.field.getSimpleName().toString();
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public XClass getDeclaringClass() {
            return this.c;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.field.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getProtoDocs() {
            return DocumentationExtractor.getDocumentation((ProtoDoc[])this.field.getAnnotationsByType(ProtoDoc.class));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != MirrorField.class) {
                return false;
            }
            return this.field.equals(((MirrorField)obj).field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return this.field.toString();
        }
    }

    private final class MirrorConstructor
    implements XConstructor {
        private final MirrorClass c;
        private final ExecutableElement executableElement;
        private final int modifiers;

        MirrorConstructor(MirrorClass c, ExecutableElement executableElement) {
            this.c = c;
            this.executableElement = executableElement;
            this.modifiers = MirrorTypeFactory.getModifiersOfElement(executableElement);
        }

        @Override
        public int getParameterCount() {
            return this.executableElement.getParameters().size();
        }

        @Override
        public String[] getParameterNames() {
            return (String[])this.executableElement.getParameters().stream().map(p -> p.getSimpleName().toString()).toArray(String[]::new);
        }

        @Override
        public XClass[] getParameterTypes() {
            return (XClass[])this.executableElement.getParameters().stream().map(p -> MirrorTypeFactory.this.fromTypeMirror(p.asType())).toArray(XClass[]::new);
        }

        @Override
        public String getName() {
            return this.executableElement.getSimpleName().toString();
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public XClass getDeclaringClass() {
            return this.c;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.executableElement.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.executableElement.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getProtoDocs() {
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != MirrorConstructor.class) {
                return false;
            }
            return this.executableElement.equals(((MirrorConstructor)obj).executableElement);
        }

        public int hashCode() {
            return this.executableElement.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier m : Modifier.values()) {
                if (!this.executableElement.getModifiers().contains((Object)m)) continue;
                sb.append((Object)m).append(' ');
            }
            sb.append(this.executableElement);
            return sb.toString();
        }

        @Override
        public String toGenericString() {
            return this.toString();
        }
    }

    private final class MirrorMethod
    implements XMethod,
    HasModelElement {
        private final MirrorClass declaringClass;
        private final ExecutableElement executableElement;
        private final int modifiers;

        MirrorMethod(MirrorClass declaringClass, ExecutableElement executableElement) {
            this.declaringClass = declaringClass;
            this.executableElement = executableElement;
            this.modifiers = MirrorTypeFactory.getModifiersOfElement(executableElement);
        }

        @Override
        public XClass getReturnType() {
            return MirrorTypeFactory.this.fromTypeMirror(this.executableElement.getReturnType());
        }

        @Override
        public XClass determineRepeatedElementType() {
            List<? extends TypeMirror> typeArguments;
            XClass returnType = this.determineOptionalReturnType();
            if (returnType.isArray()) {
                return returnType.getComponentType();
            }
            if (returnType.isAssignableTo(Collection.class) && (typeArguments = ((DeclaredType)this.unwrapOptionalReturnType()).getTypeArguments()).size() == 1) {
                TypeMirror arg = typeArguments.get(0);
                return MirrorTypeFactory.this.fromTypeMirror(arg);
            }
            throw new IllegalStateException("Not a repeatable field");
        }

        @Override
        public XClass determineOptionalReturnType() {
            return MirrorTypeFactory.this.fromTypeMirror(this.unwrapOptionalReturnType());
        }

        private TypeMirror unwrapOptionalReturnType() {
            if (this.getReturnType() == MirrorTypeFactory.this.fromClass(Optional.class)) {
                return ((DeclaredType)this.executableElement.getReturnType()).getTypeArguments().get(0);
            }
            return this.executableElement.getReturnType();
        }

        @Override
        public int getParameterCount() {
            return this.executableElement.getParameters().size();
        }

        @Override
        public String[] getParameterNames() {
            return (String[])this.executableElement.getParameters().stream().map(p -> p.getSimpleName().toString()).toArray(String[]::new);
        }

        @Override
        public XClass[] getParameterTypes() {
            return (XClass[])this.executableElement.getParameters().stream().map(p -> MirrorTypeFactory.this.fromTypeMirror(p.asType())).toArray(XClass[]::new);
        }

        @Override
        public String getName() {
            return this.executableElement.getSimpleName().toString();
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.executableElement.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.executableElement.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getProtoDocs() {
            return DocumentationExtractor.getDocumentation((ProtoDoc[])this.executableElement.getAnnotationsByType(ProtoDoc.class));
        }

        @Override
        public Element getElement() {
            return this.executableElement;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != MirrorMethod.class) {
                return false;
            }
            return this.executableElement.equals(((MirrorMethod)obj).executableElement);
        }

        public int hashCode() {
            return this.executableElement.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier m : Modifier.values()) {
                if (!this.executableElement.getModifiers().contains((Object)m)) continue;
                sb.append((Object)m).append(' ');
            }
            sb.append(this.executableElement.getReturnType()).append(' ').append(this.executableElement.getEnclosingElement().getSimpleName()).append('.').append(this.executableElement);
            return sb.toString();
        }

        @Override
        public String toGenericString() {
            return this.toString();
        }
    }

    private final class MirrorArray
    implements XClass,
    HasModelElement {
        private final XClass componentType;

        MirrorArray(XClass componentType) {
            this.componentType = componentType;
        }

        @Override
        public XTypeFactory getFactory() {
            return MirrorTypeFactory.this;
        }

        @Override
        public Class<?> asClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return "[" + this.componentType.getName();
        }

        @Override
        public String getSimpleName() {
            return this.componentType.getSimpleName() + "[]";
        }

        @Override
        public String getCanonicalName() {
            String canonicalName = this.componentType.getCanonicalName();
            return canonicalName != null ? canonicalName + "[]" : null;
        }

        @Override
        public String getPackageName() {
            return this.componentType.getPackageName();
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isEnum() {
            return false;
        }

        @Override
        public Iterable<? extends XEnumConstant> getEnumConstants() {
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public XEnumConstant getEnumConstant(String name) {
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public XClass getComponentType() {
            return this.componentType;
        }

        @Override
        public XClass getEnclosingClass() {
            return null;
        }

        @Override
        public XClass getSuperclass() {
            return null;
        }

        @Override
        public XClass[] getInterfaces() {
            return EMPTY_XCLASS_ARRAY;
        }

        @Override
        public String[] getGenericInterfaceParameterTypes(Class<?> c) {
            return null;
        }

        @Override
        public boolean isAssignableTo(XClass c) {
            if (this == c) {
                return true;
            }
            if (!c.isArray()) {
                return false;
            }
            return this.componentType.isAssignableTo(c.getComponentType());
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return null;
        }

        @Override
        public String getProtoDocs() {
            return null;
        }

        @Override
        public XMethod getMethod(String methodName, XClass ... argTypes) {
            return null;
        }

        @Override
        public Iterable<? extends XField> getDeclaredFields() {
            return null;
        }

        @Override
        public int getModifiers() {
            return 17;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public XConstructor getDeclaredConstructor(XClass ... argTypes) {
            return null;
        }

        @Override
        public Iterable<? extends XConstructor> getDeclaredConstructors() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<? extends XMethod> getDeclaredMethods() {
            return Collections.emptyList();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof XClass)) {
                return false;
            }
            XClass other = (XClass)obj;
            return other.isArray() && this.getName().equals(other.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return "[" + this.componentType.toString();
        }

        @Override
        public Element getElement() {
            return ((HasModelElement)((Object)this.componentType)).getElement();
        }
    }

    private static final class MirrorEnumConstant
    implements XEnumConstant {
        private final XClass declaringClass;
        private final VariableElement e;
        private final int ordinal;
        private final int modifiers;

        MirrorEnumConstant(XClass declaringClass, VariableElement e, int ordinal) {
            this.declaringClass = declaringClass;
            this.e = e;
            this.ordinal = ordinal;
            this.modifiers = MirrorTypeFactory.getModifiersOfElement(e);
        }

        @Override
        public int getOrdinal() {
            return this.ordinal;
        }

        @Override
        public String getName() {
            return this.e.getSimpleName().toString();
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.e.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.e.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getProtoDocs() {
            return DocumentationExtractor.getDocumentation((ProtoDoc[])this.e.getAnnotationsByType(ProtoDoc.class));
        }

        @Override
        public XClass getDeclaringClass() {
            return this.declaringClass;
        }
    }

    private final class MirrorClass
    implements XClass,
    HasModelElement {
        private final DeclaredType typeMirror;
        private final TypeElement typeElement;
        private final Map<VariableElement, MirrorEnumConstant> enumConstants;
        private final Map<ExecutableElement, MirrorConstructor> constructorCache = new HashMap<ExecutableElement, MirrorConstructor>();
        private final Map<ExecutableElement, MirrorMethod> methodCache = new HashMap<ExecutableElement, MirrorMethod>();
        private final Map<VariableElement, MirrorField> fieldCache = new HashMap<VariableElement, MirrorField>();
        private final int modifiers;

        MirrorClass(DeclaredType typeMirror) {
            this.typeMirror = typeMirror;
            this.typeElement = (TypeElement)typeMirror.asElement();
            if (this.typeElement.getKind() == ElementKind.ENUM) {
                int[] ordinal = new int[]{0};
                this.enumConstants = this.typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ENUM_CONSTANT).map(e -> (VariableElement)e).collect(Collectors.toMap(e -> e, e -> {
                    int n = ordinal[0];
                    ordinal[0] = n + 1;
                    return new MirrorEnumConstant(this, (VariableElement)e, n);
                }, (k, v) -> {
                    throw new IllegalStateException("Elements must be distinct");
                }, LinkedHashMap::new));
            } else {
                this.enumConstants = null;
            }
            this.modifiers = MirrorTypeFactory.getModifiersOfElement(this.typeElement);
        }

        @Override
        public XTypeFactory getFactory() {
            return MirrorTypeFactory.this;
        }

        @Override
        public Class<?> asClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return MirrorTypeFactory.this.elements.getBinaryName(this.typeElement).toString();
        }

        @Override
        public String getSimpleName() {
            return this.typeElement.getSimpleName().toString();
        }

        @Override
        public String getCanonicalName() {
            return this.typeElement.getQualifiedName().toString();
        }

        @Override
        public String getPackageName() {
            PackageElement packageElement = MirrorTypeFactory.this.elements.getPackageOf(this.typeElement);
            return packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public boolean isEnum() {
            return this.enumConstants != null;
        }

        @Override
        public Iterable<? extends XEnumConstant> getEnumConstants() {
            if (this.enumConstants != null) {
                return this.enumConstants.values();
            }
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public XEnumConstant getEnumConstant(String name) {
            if (this.enumConstants == null) {
                throw new IllegalStateException(this.getName() + " is not an enum");
            }
            for (VariableElement v : this.enumConstants.keySet()) {
                if (!name.equals(v.getSimpleName().toString())) continue;
                return this.enumConstants.get(v);
            }
            return null;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public XClass getComponentType() {
            throw new IllegalStateException(this.getName() + " is not an array");
        }

        @Override
        public XClass getEnclosingClass() {
            Element enclosingElement = this.typeElement.getEnclosingElement();
            return enclosingElement.getKind() == ElementKind.CLASS ? MirrorTypeFactory.this.fromTypeMirror(enclosingElement.asType()) : null;
        }

        @Override
        public XClass getSuperclass() {
            TypeMirror superclass = this.typeElement.getSuperclass();
            return superclass.getKind() == TypeKind.DECLARED ? MirrorTypeFactory.this.fromTypeMirror(superclass) : null;
        }

        @Override
        public XClass[] getInterfaces() {
            List<? extends TypeMirror> interfaces = this.typeElement.getInterfaces();
            XClass[] xclasses = new XClass[interfaces.size()];
            for (int i = 0; i < xclasses.length; ++i) {
                xclasses[i] = MirrorTypeFactory.this.fromTypeMirror(interfaces.get(i));
            }
            return xclasses;
        }

        @Override
        public String[] getGenericInterfaceParameterTypes(Class<?> c) {
            String name = c.getCanonicalName();
            if (name == null) {
                name = c.getName();
            }
            TypeMirror i = MirrorTypeFactory.this.types.erasure(MirrorTypeFactory.this.elements.getTypeElement(name).asType());
            return this.getGenericInterfaceParameterTypes(this.typeMirror, i);
        }

        private String[] getGenericInterfaceParameterTypes(TypeMirror typeMirror, TypeMirror i) {
            if (MirrorTypeFactory.this.types.isAssignable(typeMirror, i)) {
                if (MirrorTypeFactory.this.types.isSameType(MirrorTypeFactory.this.types.erasure(typeMirror), i)) {
                    return (String[])((DeclaredType)typeMirror).getTypeArguments().stream().map(t -> {
                        if (t instanceof TypeVariable) {
                            t = ((TypeVariable)t).getUpperBound();
                        }
                        return t.toString();
                    }).toArray(String[]::new);
                }
                for (TypeMirror typeMirror2 : MirrorTypeFactory.this.types.directSupertypes(typeMirror)) {
                    String[] params = this.getGenericInterfaceParameterTypes(typeMirror2, i);
                    if (params == null) continue;
                    return params;
                }
            }
            return null;
        }

        @Override
        public boolean isAssignableTo(XClass c) {
            if (this == c) {
                return true;
            }
            if (c.isPrimitive()) {
                return false;
            }
            TypeMirror secondType = MirrorTypeFactory.this.getTypeMirror(c.getCanonicalName());
            return MirrorTypeFactory.this.types.isAssignable(MirrorTypeFactory.this.types.erasure(this.typeMirror), MirrorTypeFactory.this.types.erasure(secondType));
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.typeElement.getAnnotation(annotationClass);
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return this.typeElement.getAnnotationsByType(annotationClass);
        }

        @Override
        public String getProtoDocs() {
            return DocumentationExtractor.getDocumentation((ProtoDoc[])this.typeElement.getAnnotationsByType(ProtoDoc.class));
        }

        @Override
        public XMethod getMethod(String methodName, XClass ... argTypes) {
            return this.cacheMethod(this.findExecutableElement(false, methodName, argTypes));
        }

        private ExecutableElement findExecutableElement(boolean isConstructor, String name, XClass[] argTypes) {
            Predicate<ExecutableElement> argFilter = e -> {
                if (e.getParameters().size() != argTypes.length) {
                    return false;
                }
                List<? extends VariableElement> parameters = e.getParameters();
                for (int i = 0; i < argTypes.length; ++i) {
                    if (argTypes[i] == MirrorTypeFactory.this.fromTypeMirror(parameters.get(i).asType())) continue;
                    return false;
                }
                return true;
            };
            List<? extends Element> members = isConstructor ? this.typeElement.getEnclosedElements() : MirrorTypeFactory.this.elements.getAllMembers(this.typeElement);
            return members.stream().filter(e -> isConstructor ? e.getKind() == ElementKind.CONSTRUCTOR : e.getKind() == ElementKind.METHOD && name.equals(e.getSimpleName().toString())).filter(e -> argFilter.test((ExecutableElement)e)).findFirst().orElse(null);
        }

        @Override
        public Iterable<? extends XField> getDeclaredFields() {
            return this.typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).map(e -> this.cacheField((VariableElement)e)).collect(Collectors.toList());
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean isLocal() {
            NestingKind nestingKind = this.typeElement.getNestingKind();
            return nestingKind == NestingKind.LOCAL || nestingKind == NestingKind.ANONYMOUS;
        }

        @Override
        public XConstructor getDeclaredConstructor(XClass ... argTypes) {
            return this.cacheConstructor(this.findExecutableElement(true, null, argTypes));
        }

        @Override
        public Iterable<? extends XConstructor> getDeclaredConstructors() {
            return this.typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> this.cacheConstructor((ExecutableElement)e)).collect(Collectors.toList());
        }

        @Override
        public Iterable<? extends XMethod> getDeclaredMethods() {
            return this.typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> this.cacheMethod((ExecutableElement)e)).collect(Collectors.toList());
        }

        private MirrorMethod cacheMethod(ExecutableElement method) {
            if (method == null) {
                return null;
            }
            MirrorClass declaringClass = (MirrorClass)MirrorTypeFactory.this.fromTypeMirror(method.getEnclosingElement().asType());
            MirrorMethod xmethod = declaringClass.methodCache.get(method);
            if (xmethod == null) {
                xmethod = new MirrorMethod(declaringClass, method);
                declaringClass.methodCache.put(method, xmethod);
            }
            return xmethod;
        }

        private MirrorConstructor cacheConstructor(ExecutableElement ctor) {
            if (ctor == null) {
                return null;
            }
            MirrorConstructor xctor = this.constructorCache.get(ctor);
            if (xctor == null) {
                xctor = new MirrorConstructor(this, ctor);
                this.constructorCache.put(ctor, xctor);
            }
            return xctor;
        }

        private MirrorField cacheField(VariableElement field2) {
            MirrorClass declaringClass = (MirrorClass)MirrorTypeFactory.this.fromTypeMirror(field2.getEnclosingElement().asType());
            MirrorField xfield = declaringClass.fieldCache.get(field2);
            if (xfield == null) {
                XEnumConstant enumConstant = field2.getKind() == ElementKind.ENUM_CONSTANT ? (XEnumConstant)declaringClass.enumConstants.get(field2) : null;
                xfield = new MirrorField(declaringClass, field2, enumConstant);
                declaringClass.fieldCache.put(field2, xfield);
            }
            return xfield;
        }

        @Override
        public Element getElement() {
            return this.typeElement;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof XClass)) {
                return false;
            }
            XClass other = (XClass)obj;
            return this.getName().equals(other.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.typeMirror.toString();
        }
    }

    private final class MirrorPrimitiveType
    implements XClass,
    HasModelElement {
        private final Class<?> clazz;
        private final TypeMirror primitiveType;

        MirrorPrimitiveType(Class<?> clazz, TypeMirror primitiveType) {
            this.clazz = clazz;
            this.primitiveType = primitiveType;
        }

        @Override
        public XTypeFactory getFactory() {
            return MirrorTypeFactory.this;
        }

        @Override
        public Class<?> asClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.clazz.getName();
        }

        @Override
        public String getSimpleName() {
            return this.clazz.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.clazz.getCanonicalName();
        }

        @Override
        public String getPackageName() {
            return null;
        }

        @Override
        public boolean isPrimitive() {
            return this.clazz != Void.TYPE;
        }

        @Override
        public boolean isEnum() {
            return false;
        }

        @Override
        public Iterable<? extends XEnumConstant> getEnumConstants() {
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public XEnumConstant getEnumConstant(String name) {
            throw new IllegalStateException(this.getName() + " is not an enum");
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public XClass getComponentType() {
            throw new IllegalStateException(this.getName() + " is not an array");
        }

        @Override
        public XClass getEnclosingClass() {
            return null;
        }

        @Override
        public XClass getSuperclass() {
            return null;
        }

        @Override
        public XClass[] getInterfaces() {
            return EMPTY_XCLASS_ARRAY;
        }

        @Override
        public String[] getGenericInterfaceParameterTypes(Class<?> c) {
            return null;
        }

        @Override
        public boolean isAssignableTo(XClass other) {
            if (this == other) {
                return true;
            }
            String secondTypeName = other.getCanonicalName();
            TypeMirror secondType = MirrorTypeFactory.this.getTypeMirror(secondTypeName);
            return MirrorTypeFactory.this.types.isSameType(this.primitiveType, secondType);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
            return null;
        }

        @Override
        public String getProtoDocs() {
            return null;
        }

        @Override
        public int getModifiers() {
            return 17;
        }

        @Override
        public XConstructor getDeclaredConstructor(XClass ... argTypes) {
            return null;
        }

        @Override
        public Iterable<? extends XConstructor> getDeclaredConstructors() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<? extends XMethod> getDeclaredMethods() {
            return Collections.emptyList();
        }

        @Override
        public XMethod getMethod(String methodName, XClass ... argTypes) {
            return null;
        }

        @Override
        public Iterable<? extends XField> getDeclaredFields() {
            return Collections.emptyList();
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MirrorPrimitiveType)) {
                return false;
            }
            MirrorPrimitiveType other = (MirrorPrimitiveType)obj;
            return this.clazz == other.clazz;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public String toString() {
            return this.clazz.toString();
        }

        @Override
        public Element getElement() {
            return MirrorTypeFactory.this.types.asElement(this.primitiveType);
        }
    }
}

