/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import com.oracle.svm.core.annotate.AlwaysInline;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.LoggerNode;
import org.jboss.logmanager.SerializedLogger;

public final class Logger
extends java.util.logging.Logger
implements Serializable {
    private static final long serialVersionUID = 5093333069125075416L;
    private final LoggerNode loggerNode;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    static final int OFF_INT = Level.OFF.intValue();
    static final int SEVERE_INT = Level.SEVERE.intValue();
    static final int WARNING_INT = Level.WARNING.intValue();
    static final int INFO_INT = Level.INFO.intValue();
    static final int CONFIG_INT = Level.CONFIG.intValue();
    static final int FINE_INT = Level.FINE.intValue();
    static final int FINER_INT = Level.FINER.intValue();
    static final int FINEST_INT = Level.FINEST.intValue();

    public static Logger getLogger(String name) {
        try {
            return (Logger)java.util.logging.Logger.getLogger(name);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The LogManager was not properly installed (you must set the \"java.util.logging.manager\" system property to \"" + LogManager.class.getName() + "\")");
        }
    }

    public static Logger getLogger(String name, String bundleName) {
        try {
            return (Logger)java.util.logging.Logger.getLogger(name, bundleName);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The LogManager was not properly installed (you must set the \"java.util.logging.manager\" system property to \"" + LogManager.class.getName() + "\")");
        }
    }

    Logger(LoggerNode loggerNode, String name) {
        super(name, null);
        super.setLevel(loggerNode.getLevel());
        this.loggerNode = loggerNode;
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return new SerializedLogger(this.getName());
    }

    @Override
    public void setFilter(Filter filter) throws SecurityException {
        this.loggerNode.setFilter(filter);
    }

    @Override
    public Filter getFilter() {
        return this.loggerNode.getFilter();
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
        this.loggerNode.setLevel(newLevel);
    }

    public void setLevelName(String newLevelName) throws SecurityException {
        this.setLevel(this.loggerNode.getContext().getLevelForName(newLevelName));
    }

    @AlwaysInline(value="Fast level checks")
    public int getEffectiveLevel() {
        return this.loggerNode.getEffectiveLevel();
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public Level getLevel() {
        return this.loggerNode.getLevel();
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public boolean isLoggable(Level level) {
        return this.loggerNode.isLoggableLevel(level.intValue());
    }

    public <V> V getAttachment(AttachmentKey<V> key) {
        return this.loggerNode.getAttachment(key);
    }

    public <V> V attach(AttachmentKey<V> key, V value) throws SecurityException {
        return this.loggerNode.attach(key, value);
    }

    public <V> V attachIfAbsent(AttachmentKey<V> key, V value) throws SecurityException {
        return this.loggerNode.attachIfAbsent(key, value);
    }

    public <V> V detach(AttachmentKey<V> key) throws SecurityException {
        return this.loggerNode.detach(key);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        this.loggerNode.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        if (handler == null) {
            return;
        }
        this.loggerNode.removeHandler(handler);
    }

    @Override
    public Handler[] getHandlers() {
        Handler[] handlers = this.loggerNode.getHandlers();
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public void setHandlers(Handler[] handlers) throws SecurityException {
        Handler[] safeHandlers;
        for (Handler handler : safeHandlers = (Handler[])handlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        this.loggerNode.setHandlers(safeHandlers);
    }

    public Handler[] getAndSetHandlers(Handler[] handlers) throws SecurityException {
        Handler[] safeHandlers;
        for (Handler handler : safeHandlers = (Handler[])handlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        return this.loggerNode.setHandlers(safeHandlers);
    }

    public boolean compareAndSetHandlers(Handler[] expected, Handler[] newHandlers) throws SecurityException {
        Object[] oldHandlers;
        Handler[] safeNewHandlers;
        Object[] safeExpectedHandlers = (Handler[])expected.clone();
        for (Handler handler : safeNewHandlers = (Handler[])newHandlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        do {
            if (Arrays.equals(oldHandlers = this.loggerNode.getHandlers(), safeExpectedHandlers)) continue;
            return false;
        } while (!this.loggerNode.compareAndSetHandlers((Handler[])oldHandlers, safeNewHandlers));
        return true;
    }

    public Handler[] clearHandlers() throws SecurityException {
        return this.loggerNode.clearHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.loggerNode.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.loggerNode.getUseParentHandlers();
    }

    public void setUseParentFilters(boolean useParentFilter) {
        this.loggerNode.setUseParentFilters(useParentFilter);
    }

    public boolean getUseParentFilters() {
        return this.loggerNode.getUseParentFilters();
    }

    @Override
    public Logger getParent() {
        LoggerNode parentNode = this.loggerNode.getParent();
        return parentNode == null ? null : parentNode.createLogger();
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        throw new SecurityException("setParent() disallowed");
    }

    public LogContext getLogContext() {
        return this.loggerNode.getContext();
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void log(LogRecord record) {
        if (!this.loggerNode.isLoggableLevel(record.getLevel().intValue())) {
            return;
        }
        this.logRaw(record);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void entering(String sourceClass, String sourceMethod) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        StringBuilder builder = new StringBuilder("ENTRY");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                builder.append(" {").append(i).append('}');
            }
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, builder.toString(), LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void exiting(String sourceClass, String sourceMethod) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void exiting(String sourceClass, String sourceMethod, Object result2) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{result2});
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "THROW", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void severe(String msg) {
        if (!this.loggerNode.isLoggableLevel(SEVERE_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.SEVERE, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void warning(String msg) {
        if (!this.loggerNode.isLoggableLevel(WARNING_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.WARNING, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void info(String msg) {
        if (!this.loggerNode.isLoggableLevel(INFO_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.INFO, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void config(String msg) {
        if (!this.loggerNode.isLoggableLevel(CONFIG_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.CONFIG, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void fine(String msg) {
        if (!this.loggerNode.isLoggableLevel(FINE_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINE, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void finer(String msg) {
        if (!this.loggerNode.isLoggableLevel(FINER_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void finest(String msg) {
        if (!this.loggerNode.isLoggableLevel(FINEST_INT)) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINEST, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void log(Level level, String msg) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void log(Level level, String msg, Object param1) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void log(Level level, String msg, Object[] params) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void log(Level level, String msg, Throwable thrown) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    @AlwaysInline(value="Fast level checks")
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    @Deprecated
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (!this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @AlwaysInline(value="Fast level checks")
    public void log(String fqcn, Level level, String message, String bundleName, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        if (level == null || fqcn == null || message == null || !this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setResourceBundleName(bundleName);
        rec.setParameters(params);
        rec.setThrown(t);
        this.logRaw(rec);
    }

    @AlwaysInline(value="Fast level checks")
    public void log(String fqcn, Level level, String message, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        if (level == null || fqcn == null || message == null || !this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setParameters(params);
        rec.setThrown(t);
        this.logRaw(rec);
    }

    @AlwaysInline(value="Fast level checks")
    public void log(String fqcn, Level level, String message, Throwable t) {
        this.log(fqcn, level, message, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, null, t);
    }

    public void logRaw(ExtLogRecord record) {
        record.setLoggerName(this.getName());
        String bundleName = this.getResourceBundleName();
        ResourceBundle bundle2 = this.getResourceBundle();
        if (bundleName != null && bundle2 != null) {
            record.setResourceBundleName(bundleName);
            record.setResourceBundle(bundle2);
        }
        try {
            if (!this.loggerNode.isLoggable(record)) {
                return;
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loggerNode.publish(record);
    }

    @AlwaysInline(value="Fast level checks")
    public void logRaw(LogRecord record) {
        this.logRaw(ExtLogRecord.wrap(record));
    }

    public String toString() {
        return "Logger '" + this.getName() + "' in context " + this.loggerNode.getContext();
    }

    public static final class AttachmentKey<V> {
        private static final AtomicInteger idSeq = new AtomicInteger();
        final int id = idSeq.getAndIncrement();

        int getId() {
            return this.id;
        }
    }
}

