/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.lang.reflect.Array;
import java.util.Arrays;
import javax.ws.rs.ext.ParamConverter;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.plugins.providers.MultiValuedAbstractParamConverter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class MultiValuedArrayParamConverter
extends MultiValuedAbstractParamConverter
implements ParamConverter<Object> {
    private Class<?> rawType;

    public MultiValuedArrayParamConverter(StringParameterInjector stringParameterInjector, String separator, Class<?> rawType) {
        super(stringParameterInjector, separator);
        this.rawType = rawType;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            throw new RuntimeException(Messages.MESSAGES.expectedArray(value.getClass().getName()));
        }
        Object[] values = new Object[Array.getLength(value)];
        if (values.length == 0) {
            return "";
        }
        if (this.rawType.getComponentType().isPrimitive()) {
            this.copyPrimitiveArray(values, value);
        } else {
            values = (Object[])value;
        }
        return this.stringify(Arrays.asList(values));
    }

    @Override
    public Object fromString(String param2) {
        String[] elements = param2.split(this.separator);
        Object array = Array.newInstance(this.rawType.getComponentType(), elements.length);
        try {
            for (int i = 0; i < elements.length; ++i) {
                Array.set(array, i, this.stringParameterInjector.extractValue(elements[i]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.errorCreatingArray(param2));
        }
        return array;
    }

    private void copyPrimitiveArray(Object[] objectArray, Object primitiveArray) {
        int primitiveArrayLength = Array.getLength(primitiveArray);
        for (int i = 0; i < primitiveArrayLength; ++i) {
            objectArray[i] = Array.get(primitiveArray, i);
        }
    }
}

