/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.util.DateUtil;

public class RequestImpl
implements Request {
    private HttpHeaders headers;
    private String varyHeader;
    private String httpMethod;
    private HttpRequest request;
    private HttpResponse response;

    public RequestImpl(HttpRequest request, HttpResponse response) {
        this.headers = request.getHttpHeaders();
        this.httpMethod = request.getHttpMethod().toUpperCase();
        this.request = request;
        this.response = response;
    }

    @Override
    public String getMethod() {
        return this.httpMethod;
    }

    private boolean isRfc7232preconditions() {
        ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
        return context != null && Boolean.parseBoolean(context.getParameter("resteasy.rfc7232preconditions"));
    }

    public MultivaluedMap<String, String> getFormParameters() {
        return this.request.getDecodedFormParameters();
    }

    @Override
    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.size() == 0) {
            throw new IllegalArgumentException(Messages.MESSAGES.variantListMustNotBeZero());
        }
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        MultivaluedMap<String, String> requestHeaders = this.headers.getRequestHeaders();
        negotiation.setAcceptHeaders((List)requestHeaders.get("Accept"));
        negotiation.setAcceptCharsetHeaders((List)requestHeaders.get("Accept-Charset"));
        negotiation.setAcceptEncodingHeaders((List)requestHeaders.get("Accept-Encoding"));
        negotiation.setAcceptLanguageHeaders((List)requestHeaders.get("Accept-Language"));
        this.varyHeader = ResponseBuilderImpl.createVaryHeader(variants);
        this.response.getOutputHeaders().add("Vary", this.varyHeader);
        return negotiation.getBestMatch(variants);
    }

    public List<EntityTag> convertEtag(List<String> tags) {
        ArrayList<EntityTag> result2 = new ArrayList<EntityTag>();
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result2.add(EntityTag.valueOf(etag.trim()));
            }
        }
        return result2;
    }

    public Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals(eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            return null;
        }
        return Response.status(412).tag(eTag);
    }

    public Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals(eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            if ("GET".equals(this.httpMethod) || "HEAD".equals(this.httpMethod)) {
                return Response.notModified(eTag);
            }
            return Response.status(412).tag(eTag);
        }
        return null;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatch;
        if (eTag == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.eTagParamNull());
        }
        Response.ResponseBuilder builder = null;
        List ifMatch = (List)this.headers.getRequestHeaders().get("If-Match");
        if (ifMatch != null && ifMatch.size() > 0) {
            builder = this.ifMatch(this.convertEtag(ifMatch), eTag);
        }
        if (builder == null && (ifNoneMatch = (List)this.headers.getRequestHeaders().get("If-None-Match")) != null && ifNoneMatch.size() > 0) {
            builder = this.ifNoneMatch(this.convertEtag(ifNoneMatch), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= RequestImpl.getTimeWithPrecisionInSeconds(lastModified)) {
            return Response.notModified();
        }
        return null;
    }

    public Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= RequestImpl.getTimeWithPrecisionInSeconds(lastModified)) {
            return null;
        }
        return Response.status(412).lastModified(lastModified);
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        if (lastModified == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.lastModifiedParamNull());
        }
        Response.ResponseBuilder builder = null;
        MultivaluedMap<String, String> headers = this.headers.getRequestHeaders();
        String ifModifiedSince = headers.getFirst("If-Modified-Since");
        if (!(ifModifiedSince == null || this.isRfc7232preconditions() && headers.containsKey("If-None-Match"))) {
            builder = this.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (!(builder != null || (ifUnmodifiedSince = headers.getFirst("If-Unmodified-Since")) == null || this.isRfc7232preconditions() && headers.containsKey("If-Match"))) {
            builder = this.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", this.varyHeader);
        }
        return builder;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.lastModifiedParamNull());
        }
        if (eTag == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.eTagParamNull());
        }
        Response.ResponseBuilder rtn = null;
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        Response.ResponseBuilder etagBuilder = this.evaluatePreconditions(eTag);
        if (lastModifiedBuilder == null && etagBuilder == null) {
            rtn = null;
        } else if (lastModifiedBuilder != null && etagBuilder == null) {
            rtn = lastModifiedBuilder;
        } else if (lastModifiedBuilder == null && etagBuilder != null) {
            rtn = etagBuilder;
        } else {
            rtn = lastModifiedBuilder;
            rtn.tag(eTag);
        }
        if (rtn != null && this.varyHeader != null) {
            rtn.header("Vary", this.varyHeader);
        }
        return rtn;
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions() {
        List ifMatch = (List)this.headers.getRequestHeaders().get("If-Match");
        if (ifMatch == null || ifMatch.size() == 0) {
            return null;
        }
        return Response.status(412);
    }

    private static long getTimeWithPrecisionInSeconds(Date date) {
        return date.getTime() / 1000L * 1000L;
    }
}

