/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.error;

import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.kie.kogito.jobs.service.model.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultErrorMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultErrorMapper.class);

    @Override
    public Response toResponse(Exception exception) {
        LOGGER.error("Handling HTTP Error", exception);
        return Response.status(Optional.ofNullable(exception).filter(WebApplicationException.class::isInstance).map(WebApplicationException.class::cast).map(WebApplicationException::getResponse).map(Response::getStatus).orElse(500)).type(MediaType.APPLICATION_JSON_TYPE).entity(new ErrorResponse(exception.getMessage())).build();
    }
}

