/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.stream;

import io.smallrye.reactive.messaging.annotations.Broadcast;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.kie.kogito.jobs.service.model.JobExecutionResponse;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobStreams {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobStreams.class);
    @Inject
    @Channel(value="job-error")
    @OnOverflow(value=OnOverflow.Strategy.BUFFER, bufferSize=10000L)
    Emitter<JobExecutionResponse> jobErrorEmitter;
    @Inject
    @Channel(value="job-success")
    Emitter<JobExecutionResponse> jobSuccessEmitter;
    @Inject
    @Channel(value="job-status-change")
    Emitter<JobDetails> jobStatusChangeEmitter;

    public JobExecutionResponse publishJobError(JobExecutionResponse response) {
        this.jobErrorEmitter.send(response);
        return response;
    }

    public JobExecutionResponse publishJobSuccess(JobExecutionResponse response) {
        this.jobSuccessEmitter.send(response);
        return response;
    }

    public JobDetails publishJobStatusChange(JobDetails scheduledJob) {
        this.jobStatusChangeEmitter.send(scheduledJob);
        return scheduledJob;
    }

    @Incoming(value="job-error")
    @Outgoing(value="job-error-events")
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public JobExecutionResponse jobErrorBroadcast(JobExecutionResponse response) {
        LOGGER.debug("Error broadcast published {}", (Object)response);
        return response;
    }

    @Incoming(value="job-success")
    @Outgoing(value="job-success-events")
    @Broadcast
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public JobExecutionResponse jobSuccessBroadcast(JobExecutionResponse response) {
        LOGGER.debug("Success broadcast published {}", (Object)response);
        return response;
    }

    @Incoming(value="job-status-change")
    @Outgoing(value="job-status-change-events")
    @Broadcast
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public JobDetails jobStatusChangeBroadcast(JobDetails job) {
        LOGGER.debug("Status change broadcast for Job {}", (Object)job);
        return job;
    }
}

