/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.NameRewriter;

@FunctionalInterface
public interface PrincipalDecoder
extends Function<Principal, String> {
    public static final PrincipalDecoder DEFAULT = Principal::getName;
    public static final PrincipalDecoder UNKNOWN = p -> null;

    public String getName(Principal var1);

    @Override
    default public String apply(Principal principal) {
        return this.getName(principal);
    }

    default public UnaryOperator<Principal> asPrincipalRewriter() {
        return principal -> {
            String result2 = this.getName((Principal)principal);
            return result2 == null ? principal : new NamePrincipal(result2);
        };
    }

    default public PrincipalDecoder withRewriter(NameRewriter nameRewriter) {
        return principal -> {
            String name = this.getName(principal);
            return name == null ? null : nameRewriter.rewriteName(name);
        };
    }

    public static PrincipalDecoder aggregate(PrincipalDecoder ... decoders) {
        Assert.checkNotNullParam("decoders", decoders);
        return principal -> {
            for (PrincipalDecoder decoder : decoders) {
                String result2 = decoder.getName(principal);
                if (result2 == null) continue;
                return result2;
            }
            return null;
        };
    }

    public static PrincipalDecoder concatenating(PrincipalDecoder former, String joinString, PrincipalDecoder latter) {
        Assert.checkNotNullParam("former", former);
        Assert.checkNotNullParam("joinString", joinString);
        Assert.checkNotNullParam("latter", latter);
        return principal -> {
            String formerName = former.getName(principal);
            String latterName = latter.getName(principal);
            if (formerName == null || latterName == null) {
                return null;
            }
            return formerName + joinString + latterName;
        };
    }

    public static PrincipalDecoder concatenating(String joinString, PrincipalDecoder ... decoders) {
        Assert.checkNotNullParam("joinString", joinString);
        Assert.checkNotNullParam("decoders", decoders);
        return principal -> {
            StringJoiner concatenatedResult = new StringJoiner(joinString);
            for (PrincipalDecoder decoder : decoders) {
                String result2 = decoder.getName(principal);
                if (result2 == null) {
                    return null;
                }
                concatenatedResult.add(result2);
            }
            return concatenatedResult.toString();
        };
    }

    public static PrincipalDecoder constant(String name) {
        return principal -> name;
    }
}

