/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.credential.Credential;

public class SSHCredential
implements Credential {
    public static File DEFAULT_SSH_DIRECTORY = new File(System.getProperty("user.home"), ".ssh");
    public static String[] DEFAULT_PRIVATE_KEYS = new String[]{"id_rsa", "id_dsa", "id_ecdsa"};
    public static String DEFAULT_KNOWN_HOSTS = "known_hosts";
    private final File sshDirectory;
    private final String[] privateKeyIdentities;
    private final Credential passphrase;
    private final String knownHostsFile;

    private SSHCredential(File sshDirectory, String[] privateKeyIdentities, Credential passphrase, String knownHostsFile) {
        this.sshDirectory = sshDirectory;
        this.privateKeyIdentities = privateKeyIdentities;
        this.passphrase = passphrase;
        this.knownHostsFile = knownHostsFile;
    }

    public File getSshDirectory() {
        return this.sshDirectory;
    }

    public String[] getPrivateKeyIdentities() {
        return this.privateKeyIdentities;
    }

    public Credential getPassphrase() {
        return this.passphrase;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    @Override
    public Credential clone() {
        return this;
    }

    public int hashCode() {
        int result2 = HashMath.multiHashOrdered(this.getClass().hashCode(), this.sshDirectory.hashCode());
        result2 = HashMath.multiHashOrdered(result2, Arrays.hashCode(this.privateKeyIdentities));
        result2 = HashMath.multiHashOrdered(result2, this.passphrase.hashCode());
        result2 = HashMath.multiHashOrdered(result2, this.knownHostsFile.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        return obj instanceof SSHCredential && this.equals((SSHCredential)obj);
    }

    private boolean equals(SSHCredential obj) {
        return Objects.equals(this.sshDirectory, obj.sshDirectory) && Objects.equals(this.privateKeyIdentities, obj.privateKeyIdentities) && this.passphrase.equals(obj.passphrase) && this.knownHostsFile.equals(obj.knownHostsFile);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File sshDirectory;
        private String[] privateKeyIdentities;
        private Credential passphrase;
        private String knownHostsFile;

        Builder() {
        }

        public Builder setSSHDirectory(String sshDirectory) {
            Assert.assertNotNull(sshDirectory);
            this.sshDirectory = new File(sshDirectory);
            return this;
        }

        public Builder setSSHDirectory(File sshDirectory) {
            Assert.assertNotNull(sshDirectory);
            this.sshDirectory = sshDirectory;
            return this;
        }

        public Builder setPrivateKeyIdentity(String privateKeyIdentity) {
            Assert.assertNotNull(privateKeyIdentity);
            return this.setPrivateKeyIdentities(new String[]{privateKeyIdentity});
        }

        public Builder setPrivateKeyIdentities(String[] privateKeyIdentities) {
            Assert.assertNotNull(privateKeyIdentities);
            this.privateKeyIdentities = privateKeyIdentities;
            return this;
        }

        public Builder setPassphrase(Credential passphrase) {
            Assert.assertNotNull(passphrase);
            this.passphrase = passphrase;
            return this;
        }

        public Builder setKnownHostsFile(String knownHostsFile) {
            Assert.assertNotNull(knownHostsFile);
            this.knownHostsFile = knownHostsFile;
            return this;
        }

        public SSHCredential build() {
            if (this.sshDirectory == null) {
                this.sshDirectory = DEFAULT_SSH_DIRECTORY;
            }
            if (this.privateKeyIdentities == null || this.privateKeyIdentities.length == 0) {
                this.privateKeyIdentities = DEFAULT_PRIVATE_KEYS;
            }
            if (this.knownHostsFile == null) {
                this.knownHostsFile = DEFAULT_KNOWN_HOSTS;
            }
            return new SSHCredential(this.sshDirectory, this.privateKeyIdentities, this.passphrase, this.knownHostsFile);
        }
    }
}

