/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.util.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String generalInvalidName$str() {
        return "ELY00009: Invalid name \"%s\"";
    }

    @Override
    public final IllegalArgumentException generalInvalidName(String str) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.generalInvalidName$str(), str));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String iterationCountNotSpecified$str() {
        return "ELY03025: Iteration count not specified for password based encryption";
    }

    @Override
    public final IllegalArgumentException iterationCountNotSpecified() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.iterationCountNotSpecified$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String saltNotSpecified$str() {
        return "ELY03026: Salt not specified for password based encryption";
    }

    @Override
    public final IllegalArgumentException saltNotSpecified() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.saltNotSpecified$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String initialKeyNotSpecified$str() {
        return "ELY03027: Initial key not specified for password based encryption";
    }

    @Override
    public final IllegalArgumentException initialKeyNotSpecified() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.initialKeyNotSpecified$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String securityProviderDoesnExist$str() {
        return "ELY03028: Security provider \"%s\" doesn't exist";
    }

    @Override
    public final IllegalArgumentException securityProviderDoesnExist(String providerName) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.securityProviderDoesnExist$str(), providerName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String noSuchKeyAlgorithm$str() {
        return "ELY03029: No such key algorithm \"%s\"";
    }

    @Override
    public final IllegalArgumentException noSuchKeyAlgorithm(String algorithmName, GeneralSecurityException cause) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchKeyAlgorithm$str(), algorithmName), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String closed$str() {
        return "ELY03030: I/O operation failed: closed";
    }

    @Override
    public final IOException closed() {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.closed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String wrongBase64InPBCompatibleMode$str() {
        return "ELY03032: Base64 string created with unsupported PicketBox version \"%s\"";
    }

    @Override
    public final IllegalArgumentException wrongBase64InPBCompatibleMode(String base64) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongBase64InPBCompatibleMode$str(), base64));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String mechanismNotSupported$str() {
        return "ELY04020: Mechanism \"%s\" not supported by transformation mapper";
    }

    @Override
    public final IllegalArgumentException mechanismNotSupported(String mechanism) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechanismNotSupported$str(), mechanism));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failedToEncode$str() {
        return "ELY08030: Failed to encode parameter specification";
    }

    @Override
    public final InvalidParameterSpecException failedToEncode(Throwable cause) {
        InvalidParameterSpecException result2 = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.failedToEncode$str(), new Object[0]));
        result2.initCause(cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failedToDecode$str() {
        return "ELY08031: Failed to decode parameter specification";
    }

    @Override
    public final IOException failedToDecode(Throwable cause) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.failedToDecode$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidParameterSpec$str() {
        return "ELY08032: Invalid parameter specification type (expected %s, got %s)";
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpec(Class<?> expected, Class<?> actual) {
        InvalidParameterSpecException result2 = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpec$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidFormat$str() {
        return "ELY08033: Invalid format given (expected %s, got %s)";
    }

    @Override
    public final IOException invalidFormat(String expected, String actual) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.invalidFormat$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String algorithmParametersNotInitialized$str() {
        return "ELY08034: Algorithm parameters instance not initialized";
    }

    @Override
    public final IllegalStateException algorithmParametersNotInitialized() {
        IllegalStateException result2 = new IllegalStateException(String.format(this.getLoggingLocale(), this.algorithmParametersNotInitialized$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

