/*
 * Decompiled with CFR 0.152.
 */
package protostream.javassist;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URL;
import protostream.javassist.ClassPath;
import protostream.javassist.JarClassPath;
import protostream.javassist.NotFoundException;

final class JarDirClassPath
implements ClassPath {
    JarClassPath[] jars;

    JarDirClassPath(String dirName) throws NotFoundException {
        File[] files2 = new File(dirName).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (files2 != null) {
            this.jars = new JarClassPath[files2.length];
            for (int i = 0; i < files2.length; ++i) {
                this.jars[i] = new JarClassPath(files2[i].getPath());
            }
        }
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        if (this.jars != null) {
            for (int i = 0; i < this.jars.length; ++i) {
                InputStream is = this.jars[i].openClassfile(classname);
                if (is == null) continue;
                return is;
            }
        }
        return null;
    }

    @Override
    public URL find(String classname) {
        if (this.jars != null) {
            for (int i = 0; i < this.jars.length; ++i) {
                URL url = this.jars[i].find(classname);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }
}

