/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.iteration;

import com.ibm.asyncutil.iteration.AsyncIterators;
import com.ibm.asyncutil.iteration.AsyncQueue;
import com.ibm.asyncutil.iteration.AsyncQueues;
import com.ibm.asyncutil.iteration.AsyncTrampoline;
import com.ibm.asyncutil.util.AsyncCloseable;
import com.ibm.asyncutil.util.Combinators;
import com.ibm.asyncutil.util.Either;
import com.ibm.asyncutil.util.StageSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface AsyncIterator<T>
extends AsyncCloseable {
    public CompletionStage<Either<End, T>> nextStage();

    @Override
    default public CompletionStage<Void> close() {
        return StageSupport.voidStage();
    }

    default public <U> AsyncIterator<U> thenApply(Function<? super T, ? extends U> fn) {
        return AsyncIterators.thenApplyImpl(this, fn, true, null);
    }

    default public <U> AsyncIterator<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return AsyncIterators.thenApplyImpl(this, fn, false, null);
    }

    default public <U> AsyncIterator<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(executor);
        return AsyncIterators.thenApplyImpl(this, fn, false, executor);
    }

    default public <U> AsyncIterator<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AsyncIterators.thenComposeImpl(this, fn, true, null);
    }

    default public <U> AsyncIterator<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AsyncIterators.thenComposeImpl(this, fn, false, null);
    }

    default public <U> AsyncIterator<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        Objects.requireNonNull(executor);
        return AsyncIterators.thenComposeImpl(this, fn, false, executor);
    }

    default public <U> AsyncIterator<U> thenFlatten(Function<? super T, ? extends AsyncIterator<U>> fn) {
        return AsyncIterator.concat(this.thenApply(fn));
    }

    default public <U> AsyncIterator<U> thenFlattenAhead(Function<? super T, ? extends CompletionStage<? extends AsyncIterator<U>>> fn, int executeAhead) {
        Objects.requireNonNull(fn);
        Function eitherF = nt -> nt.fold(stop -> End.endStage(), (? super R t) -> ((CompletionStage)fn.apply(t)).thenApply(Either::right));
        AsyncIterators.PartiallyEagerAsyncIterator nestedAsyncIterator = new AsyncIterators.PartiallyEagerAsyncIterator(this, executeAhead, eitherF, AsyncIterator::close);
        return AsyncIterator.concat(nestedAsyncIterator);
    }

    default public <U> AsyncIterator<U> thenComposeAhead(Function<? super T, ? extends CompletionStage<U>> fn, int executeAhead) {
        Objects.requireNonNull(fn);
        Function eitherF = nt -> nt.fold(stop -> End.endStage(), (? super R t) -> ((CompletionStage)fn.apply(t)).thenApply(Either::right));
        return new AsyncIterators.PartiallyEagerAsyncIterator(this, executeAhead, eitherF, null);
    }

    default public AsyncIterator<T> filter(Predicate<? super T> predicate) {
        final Predicate<Either> shouldKeepLooking = either -> either.fold(end -> false, predicate.negate()::test);
        return new AsyncIterator<T>(){

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                return AsyncIterator.this.nextStage().thenCompose(t -> AsyncTrampoline.asyncWhile(shouldKeepLooking, c -> AsyncIterator.this.nextStage(), t));
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public <U> AsyncIterator<U> filterApply(Function<? super T, Optional<U>> fn) {
        return this.thenApply(fn).filter(Optional::isPresent).thenApply(Optional::get);
    }

    default public <U> AsyncIterator<U> filterCompose(Function<? super T, ? extends CompletionStage<Optional<U>>> fn) {
        return this.thenCompose(fn).filter(Optional::isPresent).thenApply(Optional::get);
    }

    default public AsyncIterator<T> take(final long n) {
        return new AsyncIterator<T>(){
            int count = 0;

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                if ((long)(++this.count) > n) {
                    return End.endStage();
                }
                return AsyncIterator.this.nextStage();
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public AsyncIterator<T> takeWhile(final Predicate<? super T> predicate) {
        return new AsyncIterator<T>(){
            boolean predicateFailed = false;

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                return AsyncIterator.this.nextStage().thenApply(either -> either.flatMap(t -> {
                    if (this.predicateFailed) {
                        return End.end();
                    }
                    if (!predicate.test(t)) {
                        this.predicateFailed = true;
                        return End.end();
                    }
                    return Either.right(t);
                }));
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public AsyncIterator<T> exceptionally(final Function<Throwable, ? extends T> fn) {
        return new AsyncIterator<T>(){

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                return AsyncIterators.convertSynchronousException(AsyncIterator.this::nextStage).exceptionally(ex -> Either.right(fn.apply(ex)));
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public AsyncIterator<T> fuse() {
        return new AsyncIterator<T>(){
            boolean end = false;

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                if (this.end) {
                    return End.endStage();
                }
                return AsyncIterator.this.nextStage().thenApply(either -> {
                    either.forEach(endMarker -> {
                        this.end = true;
                    }, t -> {});
                    return either;
                });
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public <A, R> AsyncIterator<R> batch(final Collector<? super T, A, R> collector, final BiPredicate<? super A, ? super T> shouldAddToBatch) {
        return new AsyncIterator<R>(){
            private Either<End, T> lastAdvance = null;

            @Override
            public CompletionStage<Either<End, R>> nextStage() {
                return this.lastAdvance == null ? AsyncIterator.this.nextStage().thenCompose(eitherT -> {
                    this.lastAdvance = eitherT;
                    return this.collectBatch();
                }) : this.collectBatch();
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }

            private CompletionStage<Either<End, R>> collectBatch() {
                return this.lastAdvance.fold(end -> End.endStage(), (? super R ignoredT) -> {
                    Object batch = collector.supplier().get();
                    return AsyncTrampoline.asyncWhile(eitherT -> eitherT.fold(end -> false, (? super R t) -> shouldAddToBatch.test(batch, t)), eitherT -> {
                        collector.accumulator().accept(batch, eitherT.fold(end -> {
                            throw new IllegalStateException();
                        }, (? super R t) -> t));
                        return AsyncIterator.this.nextStage();
                    }, this.lastAdvance).thenApply(eitherT -> {
                        this.lastAdvance = eitherT;
                        return Either.right(AsyncIterators.finishContainer(batch, collector));
                    });
                });
            }
        };
    }

    default public <A, R> AsyncIterator<R> batch(final Collector<? super T, A, R> collector, final int batchSize) {
        class CountingCollector
        implements Collector<T, 1CountingContainer, R>,
        Supplier<1CountingContainer>,
        BiConsumer<1CountingContainer, T>,
        BinaryOperator<1CountingContainer>,
        BiPredicate<1CountingContainer, T> {
            private final Supplier<A> parentSupplier;
            private final BiConsumer<A, ? super T> parentAccumulator;
            private final BinaryOperator<A> parentCombiner;
            private final Set<Collector.Characteristics> characteristics;

            CountingCollector() {
                this.parentSupplier = collector.supplier();
                this.parentAccumulator = collector.accumulator();
                this.parentCombiner = collector.combiner();
                EnumSet<Collector.Characteristics> characteristics = EnumSet.copyOf(collector.characteristics());
                characteristics.remove((Object)Collector.Characteristics.CONCURRENT);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                this.characteristics = Collections.unmodifiableSet(characteristics);
            }

            @Override
            public Supplier<1CountingContainer> supplier() {
                return this;
            }

            @Override
            public BiConsumer<1CountingContainer, T> accumulator() {
                return this;
            }

            @Override
            public BinaryOperator<1CountingContainer> combiner() {
                return this;
            }

            @Override
            public Function<1CountingContainer, R> finisher() {
                return countingContainer -> {
                    class CountingContainer {
                        final A container;
                        int size;

                        public CountingContainer(A container, int size) {
                            this.container = container;
                            this.size = size;
                        }
                    }
                    return AsyncIterators.finishContainer(countingContainer.container, collector);
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return this.characteristics;
            }

            @Override
            public 1CountingContainer get() {
                return new CountingContainer(this.parentSupplier.get(), 0);
            }

            @Override
            public void accept(1CountingContainer countingContainer, T t) {
                this.parentAccumulator.accept(countingContainer.container, t);
                ++countingContainer.size;
            }

            @Override
            public 1CountingContainer apply(1CountingContainer c1, 1CountingContainer c2) {
                Object combined = this.parentCombiner.apply(c1.container, c2.container);
                if (combined == c1.container) {
                    c1.size += c2.size;
                    return c1;
                }
                return new CountingContainer(combined, c1.size + c2.size);
            }

            @Override
            public boolean test(1CountingContainer countingContainer, T t) {
                return countingContainer.size < batchSize;
            }
        }
        CountingCollector counter2 = new CountingCollector();
        return this.batch(counter2, counter2);
    }

    default public <U> CompletionStage<U> fold(U identity, BiFunction<U, ? super T, U> accumulator) {
        Object[] uarr = new Object[]{identity};
        return this.collect(() -> uarr, (u, t) -> {
            uarr[0] = accumulator.apply(uarr[0], t);
        }).thenApply(arr -> arr[0]);
    }

    default public CompletionStage<T> fold(T identity, final BinaryOperator<T> accumulator) {
        BiFunction biAccumulator = new BiFunction<T, T, T>(){

            @Override
            public T apply(T t, T u) {
                return accumulator.apply(t, u);
            }
        };
        return this.fold(identity, biAccumulator);
    }

    default public CompletionStage<Void> consume() {
        return AsyncTrampoline.asyncWhile(() -> this.nextStage().thenApply(Either::isRight));
    }

    default public <R, A> CompletionStage<R> collect(Collector<? super T, A, R> collector) {
        Object container = collector.supplier().get();
        BiConsumer acc2 = collector.accumulator();
        return this.forEach(t -> acc2.accept(container, (Object)t)).thenApply(ig -> AsyncIterators.finishContainer(container, collector));
    }

    default public <R> CompletionStage<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        Object container = supplier.get();
        return this.forEach(t -> accumulator.accept(container, (Object)t)).thenApply(ig -> container);
    }

    default public CompletionStage<Void> forEach(Consumer<? super T> action) {
        return AsyncTrampoline.asyncWhile(() -> this.nextStage().thenApply(eitherT -> {
            eitherT.forEach(ig -> {}, action);
            return eitherT.isRight();
        }));
    }

    default public CompletionStage<Optional<T>> find(Predicate<? super T> predicate) {
        CompletionStage<Either> future = AsyncIterators.convertSynchronousException(this.filter(predicate)::nextStage);
        return future.thenApply(e -> e.right());
    }

    public static <T> AsyncIterator<T> concat(Iterator<? extends AsyncIterator<T>> asyncIterators) {
        if (!asyncIterators.hasNext()) {
            return AsyncIterator.empty();
        }
        return new AsyncIterators.ConcatAsyncIterator(asyncIterators);
    }

    public static <T> AsyncIterator<T> concat(Collection<? extends AsyncIterator<T>> asyncIterators) {
        final Iterator<AsyncIterator<T>> iter = asyncIterators.iterator();
        if (!iter.hasNext()) {
            return AsyncIterator.empty();
        }
        return new AsyncIterators.ConcatAsyncIterator<T>(iter){

            @Override
            public CompletionStage<Void> close() {
                CompletionStage<Void> superClose = super.close();
                if (iter.hasNext()) {
                    ArrayList<CompletionStage<Void>> remainingIters = new ArrayList<CompletionStage<Void>>();
                    do {
                        remainingIters.add(((AsyncIterator)iter.next()).close());
                    } while (iter.hasNext());
                    return superClose.thenCombine(Combinators.allOf(remainingIters), (ig1, ig2) -> null);
                }
                return superClose;
            }
        };
    }

    public static <T> AsyncIterator<T> concat(final AsyncIterator<AsyncIterator<T>> asyncIterators) {
        return new AsyncIterator<T>(){
            AsyncIterator<T> curr = AsyncIterator.empty();

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                if (this.curr == null) {
                    return End.endStage();
                }
                return AsyncIterators.asyncWhileAsyncInitial(either -> !either.isRight() && this.curr != null, either -> either.fold(end -> StageSupport.thenComposeOrRecover(AsyncIterators.convertSynchronousException(this.curr::close), (t, throwable) -> throwable == null ? asyncIterators.nextStage() : StageSupport.completedStage(Either.right(AsyncIterators.errorOnce(throwable)))).thenCompose(nextIt -> {
                    this.curr = nextIt.right().orElse(null);
                    return this.curr != null ? this.curr.nextStage() : End.endStage();
                }), (? super R t) -> StageSupport.completedStage(either)), this.curr.nextStage());
            }

            @Override
            public CompletionStage<Void> close() {
                if (this.curr == null) {
                    return asyncIterators.close();
                }
                return StageSupport.thenComposeOrRecover(AsyncIterators.convertSynchronousException(asyncIterators::close), (t, ex) -> {
                    CompletionStage<Void> ret = this.curr.close();
                    if (ex != null) {
                        ret = ret.thenCompose(ig -> StageSupport.exceptionalStage(ex));
                    }
                    return ret;
                });
            }
        };
    }

    public static <T, U, V> AsyncIterator<V> zipWith(final AsyncIterator<T> tIt, final AsyncIterator<U> uIt, final BiFunction<? super T, ? super U, V> fn) {
        return new AsyncIterator<V>(){

            @Override
            public CompletionStage<Either<End, V>> nextStage() {
                CompletionStage<Either> tFuture = AsyncIterators.convertSynchronousException(tIt::nextStage);
                CompletionStage uFuture = AsyncIterators.convertSynchronousException(uIt::nextStage);
                return tFuture.thenCombine(uFuture, (et, eu) -> AsyncIterators.zipWith(et, eu, fn));
            }

            @Override
            public CompletionStage<Void> close() {
                CompletionStage[] completionStageArray = new CompletionStage[2];
                completionStageArray[0] = AsyncIterators.convertSynchronousException(tIt::close);
                completionStageArray[1] = AsyncIterators.convertSynchronousException(uIt::close);
                return Combinators.allOf(Arrays.asList(completionStageArray));
            }
        };
    }

    public static <T> AsyncIterator<T> empty() {
        return AsyncIterators.EMPTY_ITERATOR;
    }

    public static <T> AsyncIterator<T> fromIterator(Iterator<? extends T> iterator) {
        return () -> StageSupport.completedStage(iterator.hasNext() ? Either.right(iterator.next()) : End.end());
    }

    public static <T> AsyncIterator<T> once(final T t) {
        return new AsyncIterator<T>(){
            Either<End, T> curr;
            {
                this.curr = Either.right(t);
            }

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                Either prev = this.curr;
                this.curr = End.end();
                return StageSupport.completedStage(prev);
            }
        };
    }

    public static <T> AsyncIterator<T> error(Throwable ex) {
        CompletionStage stage = StageSupport.exceptionalStage(ex);
        return () -> stage;
    }

    public static <T> AsyncIterator<T> repeat(T t) {
        CompletionStage ret = StageSupport.completedStage(Either.right(t));
        return () -> ret;
    }

    public static AsyncIterator<Long> range(final long start, final long end) {
        if (start >= end) {
            return AsyncIterator.empty();
        }
        return new AsyncIterator<Long>(){
            long counter;
            {
                this.counter = start;
            }

            @Override
            public CompletionStage<Either<End, Long>> nextStage() {
                if (this.counter < end) {
                    return StageSupport.completedStage(Either.right(this.counter++));
                }
                return End.endStage();
            }
        };
    }

    public static AsyncIterator<Long> infiniteRange(final long start) {
        return new AsyncIterator<Long>(){
            long counter;
            {
                this.counter = start;
            }

            @Override
            public CompletionStage<Either<End, Long>> nextStage() {
                return StageSupport.completedStage(Either.right(this.counter++));
            }
        };
    }

    public static <T> AsyncIterator<T> unordered(Collection<? extends CompletionStage<T>> stages) {
        int size = stages.size();
        if (size == 0) {
            return AsyncIterator.empty();
        }
        AtomicInteger count = new AtomicInteger();
        AsyncQueue<Either> channel = AsyncQueues.unbounded();
        for (CompletionStage<Object> completionStage : stages) {
            completionStage.whenComplete((t, ex) -> {
                Either<Throwable, Object> toSend = ex != null ? Either.left(ex) : Either.right(t);
                channel.send(toSend);
                if (count.incrementAndGet() == size) {
                    channel.terminate();
                }
            });
        }
        return channel.thenCompose(either -> either.fold(StageSupport::exceptionalStage, StageSupport::completedStage));
    }

    public static <T> AsyncIterator<T> generate(Supplier<? extends CompletionStage<T>> supplier) {
        return () -> ((CompletionStage)supplier.get()).thenApply(Either::right);
    }

    public static <T> AsyncIterator<T> supply(Supplier<? extends CompletionStage<Either<End, T>>> supplier) {
        return supplier::get;
    }

    public static <T> AsyncIterator<T> unfold(final T seed, final Function<? super T, ? extends CompletionStage<Either<End, T>>> f) {
        return new AsyncIterator<T>(){
            CompletionStage<Either<End, T>> prev;
            {
                this.prev = StageSupport.completedStage(Either.right(seed));
            }

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                CompletionStage ret = this.prev;
                this.prev = this.prev.thenCompose(nxt -> nxt.fold(end -> End.endStage(), f));
                return ret;
            }
        };
    }

    public static enum End {
        END;

        private static final Either<End, ?> ITERATION_END;
        private static final CompletionStage<? extends Either<End, ?>> END_FUTURE;

        public static <T> Either<End, T> end() {
            return ITERATION_END;
        }

        public static <T> CompletionStage<Either<End, T>> endStage() {
            return END_FUTURE;
        }

        public String toString() {
            return "End of iteration";
        }

        static {
            ITERATION_END = Either.left(END);
            END_FUTURE = StageSupport.completedStage(ITERATION_END);
        }
    }
}

