/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.logging;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.formatters.PatternFormatter;

public class QuarkusDelayedHandler
extends ExtHandler {
    public static final String QUARKUS_LOG_MAX_STARTUP_RECORDS = "quarkus-log-max-startup-records";
    private final Deque<ExtLogRecord> logRecords = new ArrayDeque<ExtLogRecord>();
    private final List<Runnable> logCloseTasks = new ArrayList<Runnable>();
    private final Set<CategoryAndLevel> droppedRecords = Collections.synchronizedSet(new HashSet());
    private final int queueLimit;
    private volatile boolean buildTimeLoggingActivated = false;
    private volatile boolean activated = false;
    private volatile boolean callerCalculationRequired = false;
    private int discardLevel = Integer.MIN_VALUE;
    private int lowestInQueue = Integer.MAX_VALUE;

    public QuarkusDelayedHandler() {
        this(Integer.getInteger(QUARKUS_LOG_MAX_STARTUP_RECORDS, 4000));
    }

    public QuarkusDelayedHandler(int queueLimit) {
        this.queueLimit = queueLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        if (this.activated) {
            this.publishToNestedHandlers(record);
            super.doPublish(record);
        } else {
            QuarkusDelayedHandler quarkusDelayedHandler = this;
            synchronized (quarkusDelayedHandler) {
                if (this.activated || this.buildTimeLoggingActivated) {
                    this.publishToNestedHandlers(record);
                    super.doPublish(record);
                } else {
                    if (record.getLevel().intValue() <= this.discardLevel) {
                        this.droppedRecords.add(new CategoryAndLevel(record.getLoggerName(), record.getLevel()));
                        return;
                    }
                    if (this.logRecords.size() >= this.queueLimit) {
                        this.compactQueue();
                        if (this.logRecords.size() >= this.queueLimit) {
                            this.droppedRecords.add(new CategoryAndLevel(record.getLoggerName(), record.getLevel()));
                            return;
                        }
                    }
                    if (this.isCallerCalculationRequired()) {
                        record.copyAll();
                    } else {
                        record.disableCallerCalculation();
                        record.copyMdc();
                    }
                    this.lowestInQueue = Integer.min(record.getLevel().intValue(), this.lowestInQueue);
                    this.logRecords.addLast(record);
                }
            }
        }
    }

    private void compactQueue() {
        if (this.lowestInQueue == Level.INFO.intValue()) {
            return;
        }
        int newLowest = Integer.MAX_VALUE;
        Iterator<ExtLogRecord> it = this.logRecords.iterator();
        while (it.hasNext()) {
            ExtLogRecord rec = it.next();
            if (rec.getLevel().intValue() == this.lowestInQueue) {
                this.droppedRecords.add(new CategoryAndLevel(rec.getLoggerName(), rec.getLevel()));
                it.remove();
                continue;
            }
            newLowest = Integer.min(rec.getLevel().intValue(), newLowest);
        }
        this.discardLevel = this.lowestInQueue;
        this.lowestInQueue = newLowest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SecurityException {
        QuarkusDelayedHandler quarkusDelayedHandler = this;
        synchronized (quarkusDelayedHandler) {
            if (!this.logRecords.isEmpty()) {
                ExtLogRecord record;
                Formatter formatter = this.getFormatter();
                if (formatter == null) {
                    formatter = new PatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
                }
                StandardOutputStreams.printError("The DelayedHandler was closed before any children handlers were configured. Messages will be written to stderr.");
                while ((record = this.logRecords.pollFirst()) != null) {
                    StandardOutputStreams.printError(formatter.format(record));
                }
            }
        }
        this.activated = false;
        super.close();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        this.activate();
    }

    @Override
    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        Handler[] result2 = super.setHandlers(newHandlers);
        this.activate();
        return result2;
    }

    public void addLoggingCloseTask(Runnable runnable) {
        this.logCloseTasks.add(runnable);
    }

    public synchronized Handler[] setBuildTimeHandlers(Handler[] newHandlers) throws SecurityException {
        ExtLogRecord record;
        Handler[] result2 = super.setHandlers(newHandlers);
        this.buildTimeLoggingActivated = true;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable(record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        return result2;
    }

    public synchronized void buildTimeComplete() {
        this.buildTimeLoggingActivated = false;
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
        this.activated = this.handlers.length != 0;
    }

    @Override
    public Handler[] clearHandlers() throws SecurityException {
        this.activated = false;
        for (Runnable i : this.logCloseTasks) {
            i.run();
        }
        return super.clearHandlers();
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired || super.isCallerCalculationRequired();
    }

    public void setCallerCalculationRequired(boolean callerCalculationRequired) {
        this.callerCalculationRequired = callerCalculationRequired;
    }

    public final boolean isActivated() {
        return this.activated;
    }

    private synchronized void activate() {
        ExtLogRecord record;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable(record) || !Logger.getLogger(record.getLoggerName()).isLoggable(record.getLevel())) continue;
            this.publishToNestedHandlers(record);
        }
        TreeMap<String, List> lostCategories = new TreeMap<String, List>();
        for (CategoryAndLevel entry : this.droppedRecords) {
            if (!Logger.getLogger(entry.category).isLoggable(entry.level)) continue;
            lostCategories.computeIfAbsent(entry.category, key -> new ArrayList()).add(entry.level);
        }
        if (lostCategories.size() > 0) {
            StringBuilder msg = new StringBuilder("The delayed handler's queue was overrun and log record(s) were lost (Did you forget to configure logging?): \n");
            for (Map.Entry entry : lostCategories.entrySet()) {
                msg.append(String.format("\t - %s: %s\n", entry.getKey(), entry.getValue()));
            }
            this.reportError(msg.toString(), null, 1);
            lostCategories.clear();
        }
        this.droppedRecords.clear();
        this.activated = true;
    }

    static final class CategoryAndLevel {
        final String category;
        final java.util.logging.Level level;

        CategoryAndLevel(String category, java.util.logging.Level level) {
            this.category = category;
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CategoryAndLevel that = (CategoryAndLevel)o;
            return Objects.equals(this.category, that.category) && Objects.equals(this.level, that.level);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.level);
        }
    }
}

