/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor;

import io.quarkus.runtime.BlockingOperationNotAllowedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SecurityConstrainer {
    public static final Uni<Object> CHECK_OK = Uni.createFrom().item(new Object());
    @Inject
    SecurityIdentityAssociation identity;
    @Inject
    SecurityCheckStorage storage;

    public void check(Method method, Object[] parameters) {
        SecurityCheck securityCheck = this.storage.getSecurityCheck(method);
        if (securityCheck != null) {
            try {
                securityCheck.apply(this.identity.getIdentity(), method, parameters);
            }
            catch (BlockingOperationNotAllowedException blockingException) {
                throw new BlockingOperationNotAllowedException("Blocking security check attempted in code running on the event loop. Make the secured method return an async type, i.e. Uni, Multi or CompletionStage, or use an authentication mechanism that sets the SecurityIdentity in a blocking manner prior to delegating the call", blockingException);
            }
        }
    }

    public Uni<?> nonBlockingCheck(Method method, Object[] parameters) {
        SecurityCheck securityCheck = this.storage.getSecurityCheck(method);
        if (securityCheck != null) {
            return this.identity.getDeferredIdentity().onItem().invoke(identity -> securityCheck.apply((SecurityIdentity)identity, method, parameters));
        }
        return CHECK_OK;
    }
}

