/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi.runtime;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class MethodDescription {
    private final String className;
    private final String methodName;
    private final String[] parameterTypes;
    private final int hashCode;

    public MethodDescription(String className, String methodName, String[] parameterTypes) {
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.hashCode = this.createHashCode();
    }

    private int createHashCode() {
        int result2 = Objects.hash(this.className, this.methodName);
        result2 = 31 * result2 + Arrays.hashCode(this.parameterTypes);
        return result2;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescription that = (MethodDescription)o;
        return this.className.equals(that.className) && this.methodName.equals(that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static MethodDescription ofMethod(Method method) {
        return new MethodDescription(method.getDeclaringClass().getName(), method.getName(), MethodDescription.typesAsStrings(method.getParameterTypes()));
    }

    public static String[] typesAsStrings(Class<?>[] parameterTypes) {
        String[] result2 = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            result2[i] = parameterTypes[i].getName();
        }
        return result2;
    }
}

