/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import java.util.Objects;

public class HttpCredentialTransport {
    private final Type transportType;
    private final String typeTarget;
    private final String authenticationScheme;

    public HttpCredentialTransport(Type transportType, String typeTarget) {
        this(transportType, typeTarget, typeTarget);
    }

    public HttpCredentialTransport(Type transportType, String typeTarget, String authenticationScheme) {
        this.transportType = Objects.requireNonNull(transportType);
        this.typeTarget = Objects.requireNonNull(typeTarget).toLowerCase();
        this.authenticationScheme = Objects.requireNonNull(authenticationScheme).toLowerCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpCredentialTransport that = (HttpCredentialTransport)o;
        if (this.transportType != that.transportType) {
            return false;
        }
        return this.typeTarget.equals(that.typeTarget) && this.authenticationScheme.equals(that.authenticationScheme);
    }

    public int hashCode() {
        int result2 = this.transportType.hashCode();
        result2 = 31 * result2 + this.typeTarget.hashCode();
        result2 = 31 * result2 + this.authenticationScheme.hashCode();
        return result2;
    }

    public String toString() {
        return "HttpCredentialTransport{transportType=" + this.transportType + ", typeTarget='" + this.typeTarget + "', authenticationScheme='" + this.authenticationScheme + "'}";
    }

    public Type getTransportType() {
        return this.transportType;
    }

    public String getTypeTarget() {
        return this.typeTarget;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public static enum Type {
        COOKIE,
        AUTHORIZATION,
        OTHER_HEADER,
        POST,
        X509;

    }
}

