/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.JwtEncryptionException;
import io.smallrye.jwt.build.JwtException;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class ImplMessages_$bundle
implements ImplMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ImplMessages_$bundle INSTANCE = new ImplMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ImplMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unsupportedSignatureAlgorithm$str() {
        return "SRJWT05000: Unsupported signature algorithm: %s";
    }

    @Override
    public final JwtSignatureException unsupportedSignatureAlgorithm(String algorithmName, Throwable throwable) {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.unsupportedSignatureAlgorithm$str(), algorithmName), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final JwtSignatureException unsupportedSignatureAlgorithm(String algorithmName) {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.unsupportedSignatureAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String encryptionKeySizeMustBeHigher$str() {
        return "SRJWT05001: A key of size 2048 bits or larger MUST be used with the '%s' algorithm";
    }

    @Override
    public final JwtEncryptionException encryptionKeySizeMustBeHigher(String algorithmName) {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.encryptionKeySizeMustBeHigher$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String joseSerializationError$str() {
        return "SRJWT05003: %s";
    }

    @Override
    public final JwtEncryptionException joseSerializationError(String errorMessage, Throwable t) {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.joseSerializationError$str(), errorMessage), t);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String directContentEncryptionUnsupported$str() {
        return "SRJWT05004: Direct content encryption is currently not supported";
    }

    @Override
    public final JwtEncryptionException directContentEncryptionUnsupported() {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.directContentEncryptionUnsupported$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unsupportedKeyEncryptionAlgorithm$str() {
        return "SRJWT05005: Unsupported key encryption algorithm: %s";
    }

    @Override
    public final JwtEncryptionException unsupportedKeyEncryptionAlgorithm(String algorithmName) {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.unsupportedKeyEncryptionAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String unsupportedContentEncryptionAlgorithm$str() {
        return "SRJWT05006: Unsupported content encryption algorithm: %s";
    }

    @Override
    public final JwtEncryptionException unsupportedContentEncryptionAlgorithm(String algorithmName) {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.unsupportedContentEncryptionAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String encryptionKeyCanNotBeLoadedFromLocation$str() {
        return "SRJWT05007: Key encryption key can not be loaded from: %s";
    }

    @Override
    public final IllegalArgumentException encryptionKeyCanNotBeLoadedFromLocation(String keyLocation) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyCanNotBeLoadedFromLocation$str(), keyLocation));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String encryptionKeyLocationNotConfigured$str() {
        return "SRJWT05008: Please set a 'smallrye.jwt.encrypt.key.location' property";
    }

    @Override
    public final IllegalArgumentException encryptionKeyLocationNotConfigured() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyLocationNotConfigured$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String signatureException$str() {
        return "SRJWT05009: ";
    }

    @Override
    public final JwtSignatureException signatureException(Throwable throwable) {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signatureException$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String signKeyPropertyRequired$str() {
        return "SRJWT05010: Inner JWT can not be created, 'smallrye.jwt.sign.key.location' is not set but the 'alg' header is: %s";
    }

    @Override
    public final JwtSignatureException signKeyPropertyRequired(String algorithmName) {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signKeyPropertyRequired$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String noneSignatureAlgorithmUnsupported$str() {
        return "SRJWT05011: None signature algorithm is currently not supported";
    }

    @Override
    public final JwtSignatureException noneSignatureAlgorithmUnsupported() {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.noneSignatureAlgorithmUnsupported$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String signJwtTokenFailed$str() {
        return "SRJWT05012: Failure to create a signed JWT token: %s";
    }

    @Override
    public final JwtSignatureException signJwtTokenFailed(String exceptionMessage, Throwable throwable) {
        JwtSignatureException result2 = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signJwtTokenFailed$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String algDoesNotMatchKeyType$str() {
        return "SRJWT05013: JWK algorithm 'alg' value does not match a key type";
    }

    @Override
    public final IllegalArgumentException algDoesNotMatchKeyType() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.algDoesNotMatchKeyType$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String publicKeyBeingUsedForSign$str() {
        return "SRJWT05014: Only PrivateKey or SecretKey can be be used to sign a token";
    }

    @Override
    public final IllegalArgumentException publicKeyBeingUsedForSign() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyBeingUsedForSign$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String readJsonFailure$str() {
        return "SRJWT05015: Failure to read the json content: %s";
    }

    @Override
    public final JwtException readJsonFailure(String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.readJsonFailure$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToParseJWK$str() {
        return "SRJWT05016: Failure to parse JWK: %s";
    }

    @Override
    public final JwtException failureToParseJWK(String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWK$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToParseJWKS$str() {
        return "SRJWT05017: Failure to parse JWK Set: %s";
    }

    @Override
    public final JwtException failureToParseJWKS(String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWKS$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String kidRequired$str() {
        return "SRJWT05018: Key id 'kid' header value must be provided";
    }

    @Override
    public final IllegalArgumentException kidRequired() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.kidRequired$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyWithKidNotFound$str() {
        return "SRJWT05019: JWK set has no key with a key id 'kid' header '%s'";
    }

    @Override
    public final IllegalArgumentException keyWithKidNotFound(String keyId) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyWithKidNotFound$str(), keyId));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String signingKeyCanNotBeLoadedFromLocation$str() {
        return "SRJWT05020: Signing key can not be loaded from: %s";
    }

    @Override
    public final IllegalArgumentException signingKeyCanNotBeLoadedFromLocation(String keyLocation) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyCanNotBeLoadedFromLocation$str(), keyLocation));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String signKeyLocationNotConfigured$str() {
        return "SRJWT05021: Please set a 'smallrye.jwt.sign.key.location' property";
    }

    @Override
    public final IllegalArgumentException signKeyLocationNotConfigured() {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signKeyLocationNotConfigured$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToParseJWTClaims$str() {
        return "SRJWT05022: Failure to parse the JWT claims: %s";
    }

    @Override
    public final JwtException failureToParseJWTClaims(String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWTClaims$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToReadPrivateKey$str() {
        return "SRJWT05024: Failure to read the private key: %s";
    }

    @Override
    public final JwtException failureToReadPrivateKey(String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToReadPrivateKey$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToOpenInputStreamFromJsonResName$str() {
        return "SRJWT05025: Failure to open the input stream from %s";
    }

    @Override
    public final JwtException failureToOpenInputStreamFromJsonResName(String jsonResName) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToOpenInputStreamFromJsonResName$str(), jsonResName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String failureToReadJsonContentFromJsonResName$str() {
        return "SRJWT05026: Failure to read the json content from %s: %s";
    }

    @Override
    public final JwtException failureToReadJsonContentFromJsonResName(String jsonResName, String exceptionMessage, Throwable throwable) {
        JwtException result2 = new JwtException(String.format(this.getLoggingLocale(), this.failureToReadJsonContentFromJsonResName$str(), jsonResName, exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String encryptionException$str() {
        return "SRJWT05027: Failure to encrypt the token";
    }

    @Override
    public final JwtEncryptionException encryptionException(Throwable throwable) {
        JwtEncryptionException result2 = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.encryptionException$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }
}

