/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.util;

import io.smallrye.jwt.util.JWTUtilMessages;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;

public class JWTUtilMessages_$bundle
implements JWTUtilMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final JWTUtilMessages_$bundle INSTANCE = new JWTUtilMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected JWTUtilMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidJWKSPublicKey$str() {
        return "Failed to decode the JWKS Public Key";
    }

    @Override
    public final UncheckedIOException invalidJWKSPublicKey(IOException ioe) {
        UncheckedIOException result2 = new UncheckedIOException(String.format(this.getLoggingLocale(), this.invalidJWKSPublicKey$str(), new Object[0]), ioe);
        JWTUtilMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unsupportedAlgorithm$str() {
        return "SRJWT00001: Unsupported key type %s";
    }

    @Override
    public final NoSuchAlgorithmException unsupportedAlgorithm(String algorithmName) {
        NoSuchAlgorithmException result2 = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.unsupportedAlgorithm$str(), algorithmName));
        JWTUtilMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String keyNotFound$str() {
        return "SRJWT00002: No resource with the named %s location exists";
    }

    @Override
    public final IOException keyNotFound(String keyLocation) {
        IOException result2 = new IOException(String.format(this.getLoggingLocale(), this.keyNotFound$str(), keyLocation));
        JWTUtilMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String requiresSymmetricAlgo$str() {
        return "SRJWT00003: Algorithm %s is not a symmetric-key algorithm";
    }

    @Override
    public final InvalidAlgorithmParameterException requiresSymmetricAlgo(String algorithmName) {
        InvalidAlgorithmParameterException result2 = new InvalidAlgorithmParameterException(String.format(this.getLoggingLocale(), this.requiresSymmetricAlgo$str(), algorithmName));
        JWTUtilMessages_$bundle._copyStackTraceMinusOne(result2);
        return result2;
    }
}

