/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.extension.LegacyEmitterImpl;
import io.smallrye.reactive.messaging.helpers.ConverterUtils;
import io.smallrye.reactive.messaging.helpers.TypeUtils;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ChannelProducer {
    @Inject
    ChannelRegistry channelRegistry;
    @Inject
    Instance<MessageConverter> converters;

    @Produces
    @Typed(value={Publisher.class, Multi.class})
    @Channel(value="")
    <T> Multi<T> produceMulti(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            Type payloadType = this.getPayloadParameterFromMessageType(first);
            if (payloadType == null) {
                return (Multi)ChannelProducer.cast(this.getPublisher(injectionPoint));
            }
            return (Multi)ChannelProducer.cast(ConverterUtils.convert(this.getPublisher(injectionPoint), this.converters, payloadType));
        }
        return (Multi)ChannelProducer.cast(ConverterUtils.convert(this.getPublisher(injectionPoint), this.converters, first).onItem().call(m -> Uni.createFrom().completionStage(m.ack())).onItem().transform(Message::getPayload).broadcast().toAllSubscribers());
    }

    @Produces
    @Deprecated
    @Typed(value={Publisher.class, Multi.class})
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Multi<T> producePublisherWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.produceMulti(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        Multi<T> multi = this.produceMulti(injectionPoint);
        return (PublisherBuilder)ChannelProducer.cast(ReactiveStreams.fromPublisher(multi));
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilderWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.producePublisherBuilder(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> org.eclipse.microprofile.reactive.messaging.Emitter<T> produceEmitter(InjectionPoint injectionPoint) {
        this.verify(injectionPoint);
        org.eclipse.microprofile.reactive.messaging.Emitter<?> emitter = this.getEmitter(injectionPoint);
        return (org.eclipse.microprofile.reactive.messaging.Emitter)ChannelProducer.cast(emitter);
    }

    @Produces
    @Channel(value="")
    <T> MutinyEmitter<T> produceMutinyEmitter(InjectionPoint injectionPoint) {
        this.verify(injectionPoint);
        MutinyEmitter<?> emitter = this.getMutinyEmitter(injectionPoint);
        return (MutinyEmitter)ChannelProducer.cast(emitter);
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Emitter<T> produceEmitterLegacy(InjectionPoint injectionPoint) {
        LegacyEmitterImpl emitter = new LegacyEmitterImpl(this.getEmitter(injectionPoint));
        return (Emitter)ChannelProducer.cast(emitter);
    }

    private Multi<? extends Message<?>> getPublisher(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        return Multi.createFrom().deferred(() -> {
            List<Publisher<Message<?>>> list = this.channelRegistry.getPublishers(name);
            if (list.isEmpty()) {
                throw ProviderExceptions.ex.illegalStateForStream(name, this.channelRegistry.getIncomingNames());
            }
            if (list.size() == 1) {
                return Multi.createFrom().publisher(list.get(0));
            }
            return Multi.createBy().merging().streams(list.stream().map(p -> p).collect(Collectors.toList()));
        });
    }

    private org.eclipse.microprofile.reactive.messaging.Emitter<?> getEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        org.eclipse.microprofile.reactive.messaging.Emitter<?> emitter = this.channelRegistry.getEmitter(name);
        if (emitter == null) {
            throw ProviderExceptions.ex.incomingNotFoundForEmitter(name);
        }
        return emitter;
    }

    private MutinyEmitter<?> getMutinyEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        MutinyEmitter<?> emitter = this.channelRegistry.getMutinyEmitter(name);
        if (emitter == null) {
            throw ProviderExceptions.ex.incomingNotFoundForEmitter(name);
        }
        return emitter;
    }

    private void verify(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0) {
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            if (arguments[0] instanceof Class && arguments[0].equals(Message.class) || arguments[0] instanceof ParameterizedType && ((ParameterizedType)arguments[0]).getRawType().equals(Message.class)) {
                throw ProviderExceptions.ex.invalidEmitterOfMessage(injectionPoint);
            }
        } else {
            throw ProviderExceptions.ex.invalidRawEmitter(injectionPoint);
        }
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    private Type getPayloadParameterFromMessageType(Type type) {
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    static String getChannelName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return ((Channel)qualifier).value();
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
        }
        throw ProviderExceptions.ex.emitterWithoutChannelAnnotation(injectionPoint);
    }

    static Channel getChannelQualifier(InjectionPoint injectionPoint) {
        for (final Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return (Channel)qualifier;
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return new Channel(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Channel.class;
                }

                @Override
                public String value() {
                    return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
                }
            };
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

