/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentialsConverter;
import io.vertx.ext.auth.impl.Codec;
import java.nio.charset.StandardCharsets;

@DataObject(generateConverter=true, publicConverter=false)
public class UsernamePasswordCredentials
implements Credentials {
    private String password;
    private String username;

    protected UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public UsernamePasswordCredentials(JsonObject jsonObject) {
        UsernamePasswordCredentialsConverter.fromJson(jsonObject, this);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public UsernamePasswordCredentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.username == null || this.username.length() == 0) {
            throw new CredentialValidationException("username cannot be null or empty");
        }
        if (this.password == null) {
            throw new CredentialValidationException("password cannot be null");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject result2 = new JsonObject();
        UsernamePasswordCredentialsConverter.toJson(this, result2);
        return result2;
    }

    public String toString() {
        return this.toJson().encode();
    }

    @Override
    public UsernamePasswordCredentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        int spc;
        if (challenge != null && !"Basic".equalsIgnoreCase(challenge.substring(0, spc = challenge.indexOf(32)))) {
            throw new IllegalArgumentException("Only 'Basic' auth-scheme is supported");
        }
        this.checkValid(null);
        return this;
    }

    @Override
    public String toHttpAuthorization() {
        String credentials = (this.username == null ? "" : this.username) + ":" + (this.password == null ? "" : this.password);
        return "Basic " + Codec.base64Encode(credentials.getBytes(StandardCharsets.UTF_8));
    }
}

