/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class TopicPartition {
    private String topic;
    private int partition;

    public TopicPartition() {
    }

    public TopicPartition(String topic, int partition) {
        this.topic = topic;
        this.partition = partition;
    }

    public TopicPartition(JsonObject json) {
        this.topic = json.getString("topic");
        this.partition = json.getInteger("partition");
    }

    public TopicPartition(TopicPartition that) {
        this.topic = that.topic;
        this.partition = that.partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public TopicPartition setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public int getPartition() {
        return this.partition;
    }

    public TopicPartition setPartition(int partition) {
        this.partition = partition;
        return this;
    }

    public JsonObject toJson() {
        return new JsonObject().put("topic", this.topic).put("partition", this.partition);
    }

    public String toString() {
        return "TopicPartition{topic=" + this.topic + ", partition=" + this.partition + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartition that = (TopicPartition)o;
        if (this.partition != that.partition) {
            return false;
        }
        return this.topic != null ? this.topic.equals(that.topic) : that.topic == null;
    }

    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + this.partition;
        result2 = 31 * result2 + (this.topic != null ? this.topic.hashCode() : 0);
        return result2;
    }
}

