/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public final class LoggingUtils {
    private LoggingUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static NavigableMap<Integer, String> generateMnemonicMap(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.generateMnemonicMap(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static NavigableMap<Integer, String> generateMnemonicMap(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<Integer, String> result2 = new TreeMap<Integer, String>(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                String prev = result2.put(NumberUtils.toInteger(value), name);
                if (prev == null) continue;
            }
            catch (Exception e) {}
        }
        return result2;
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.getAmbiguousMenmonics(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Integer> result2 = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        TreeMap opcodesMap = new TreeMap(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                Integer key = NumberUtils.toInteger(value);
                ArrayList<String> nameList = (ArrayList<String>)opcodesMap.get(key);
                if (nameList == null) {
                    nameList = new ArrayList<String>();
                    opcodesMap.put(key, nameList);
                }
                nameList.add(name);
                int numOpcodes = nameList.size();
                if (numOpcodes <= 1) continue;
                result2.put(name, key);
                if (numOpcodes != 2) continue;
                result2.put((String)nameList.get(0), key);
            }
            catch (Exception e) {}
        }
        return result2;
    }

    public static Collection<Field> getMnemonicFields(Class<?> clazz, Predicate<? super Field> acceptor) {
        return ReflectionUtils.getMatchingFields(clazz, f -> {
            int mods = f.getModifiers();
            if (!(Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods))) {
                return false;
            }
            Class<?> type = f.getType();
            if (!NumberUtils.isNumericClass(type)) {
                return false;
            }
            return acceptor.test((Field)f);
        });
    }

    public static boolean isLoggable(Level level, Level threshold) {
        if (level == null || threshold == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(threshold)) {
            return false;
        }
        if (Level.ALL.equals(threshold)) {
            return true;
        }
        return level.intValue() >= threshold.intValue();
    }

    public static SimplifiedLog wrap(final Logger logger2) {
        if (logger2 == null) {
            return SimplifiedLog.EMPTY;
        }
        return new SimplifiedLog(){

            @Override
            public void log(Level level, Object message, Throwable t) {
                if (this.isEnabled(level)) {
                    LoggingUtils.logMessage(logger2, level, message, t);
                }
            }

            @Override
            public boolean isEnabled(Level level) {
                return LoggingUtils.isLoggable(logger2, level);
            }
        };
    }

    public static void logMessage(Logger logger2, Level level, Object message, Throwable t) {
        if (logger2 == null || level == null || Level.OFF.equals(level)) {
            return;
        }
        if (Level.SEVERE.equals(level)) {
            logger2.error(Objects.toString(message), t);
        } else if (Level.WARNING.equals(level)) {
            logger2.warn(Objects.toString(message), t);
        } else if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            logger2.info(Objects.toString(message), t);
        } else if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            logger2.debug(Objects.toString(message), t);
        } else {
            logger2.trace(Objects.toString(message), t);
        }
    }

    public static boolean isLoggable(Logger logger2, Level level) {
        if (logger2 == null || level == null || Level.OFF.equals(level)) {
            return false;
        }
        if (Level.SEVERE.equals(level)) {
            return logger2.isErrorEnabled();
        }
        if (Level.WARNING.equals(level)) {
            return logger2.isWarnEnabled();
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return logger2.isInfoEnabled();
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return logger2.isDebugEnabled();
        }
        return logger2.isTraceEnabled();
    }

    public static <T> Consumer<T> loggingClosure(Logger logger2, Level level) {
        return LoggingUtils.loggingClosure(logger2, level, null);
    }

    public static <T> Consumer<T> loggingClosure(Logger logger2, Level level, Throwable t) {
        Objects.requireNonNull(level, "No level provided");
        if (Level.OFF.equals(level)) {
            return LoggingUtils.nologClosure(logger2);
        }
        if (Level.SEVERE.equals(level)) {
            return LoggingUtils.errorClosure(logger2, t);
        }
        if (Level.WARNING.equals(level)) {
            return LoggingUtils.warnClosure(logger2, t);
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return LoggingUtils.infoClosure(logger2, t);
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return LoggingUtils.debugClosure(logger2, t);
        }
        return LoggingUtils.traceClosure(logger2, t);
    }

    public static <T> Consumer<T> nologClosure(Logger logger2) {
        Objects.requireNonNull(logger2, "No logger provided");
        return t -> {};
    }

    public static <T> Consumer<T> errorClosure(Logger logger2) {
        return LoggingUtils.errorClosure(logger2, null);
    }

    public static <T> Consumer<T> errorClosure(final Logger logger2, final Throwable thrown) {
        Objects.requireNonNull(logger2, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger2.isErrorEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger2.error(msg);
                    } else {
                        logger2.error(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "ERROR";
            }
        };
    }

    public static <T> Consumer<T> warnClosure(Logger logger2) {
        return LoggingUtils.warnClosure(logger2, null);
    }

    public static <T> Consumer<T> warnClosure(final Logger logger2, final Throwable thrown) {
        Objects.requireNonNull(logger2, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger2.isWarnEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger2.warn(msg);
                    } else {
                        logger2.warn(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "WARN";
            }
        };
    }

    public static <T> Consumer<T> infoClosure(Logger logger2) {
        return LoggingUtils.infoClosure(logger2, null);
    }

    public static <T> Consumer<T> infoClosure(final Logger logger2, final Throwable thrown) {
        Objects.requireNonNull(logger2, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger2.isInfoEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger2.info(msg);
                    } else {
                        logger2.info(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "INFO";
            }
        };
    }

    public static <T> Consumer<T> debugClosure(Logger logger2) {
        return LoggingUtils.debugClosure(logger2, null);
    }

    public static <T> Consumer<T> debugClosure(final Logger logger2, final Throwable thrown) {
        Objects.requireNonNull(logger2, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger2.isDebugEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger2.debug(msg);
                    } else {
                        logger2.debug(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "DEBUG";
            }
        };
    }

    public static <T> Consumer<T> traceClosure(Logger logger2) {
        return LoggingUtils.traceClosure(logger2, null);
    }

    public static <T> Consumer<T> traceClosure(final Logger logger2, final Throwable thrown) {
        Objects.requireNonNull(logger2, "No logger provided");
        return new Consumer<T>(){

            @Override
            public void accept(T input) {
                if (logger2.isTraceEnabled()) {
                    String msg = String.valueOf(input);
                    if (thrown == null) {
                        logger2.trace(msg);
                    } else {
                        logger2.trace(msg, thrown);
                    }
                }
            }

            public String toString() {
                return "TRACE";
            }
        };
    }
}

