/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;

final class Reductions {
    private Reductions() {
    }

    static <T> Collector<T, ?, Optional<T>> reduce(BinaryOperator<T> reducer2) {
        Objects.requireNonNull(reducer2, "Reduction function must not be null");
        return Collector.of(Reduction::new, (r, t) -> {
            if (((Reduction)r).value == null) {
                ((Reduction)r).value = t;
            } else {
                ((Reduction)r).value = reducer2.apply(((Reduction)r).value, t);
            }
        }, (r, s) -> {
            if (((Reduction)r).value == null) {
                return r.replace(((Reduction)s).value);
            }
            if (((Reduction)s).value != null) {
                return r.replace(reducer2.apply(((Reduction)r).value, ((Reduction)s).value));
            }
            return r;
        }, r -> Optional.ofNullable(((Reduction)r).value), new Collector.Characteristics[0]);
    }

    static <T> Collector<T, ?, T> reduce(T identity, BinaryOperator<T> reducer2) {
        Objects.requireNonNull(reducer2, "Reduction function must not be null");
        return Collector.of(() -> new Reduction<Object>(identity), (r, t) -> ((Reduction)r).value = reducer2.apply(((Reduction)r).value, t), (r, s) -> r.replace(reducer2.apply(((Reduction)r).value, ((Reduction)s).value)), r -> ((Reduction)r).value, new Collector.Characteristics[0]);
    }

    private static class Reduction<T> {
        private T value;

        Reduction() {
        }

        Reduction(T value) {
            this.value = value;
        }

        Reduction<T> replace(T newValue) {
            this.value = newValue;
            return this;
        }
    }
}

