/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.BoundedConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.ConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.commons.util.BloomFilter;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.MurmurHash3BloomFilter;
import org.infinispan.commons.util.Util;

public class NearCacheService<K, V>
implements NearCache<K, V> {
    private static final Log log = LogFactory.getLog(NearCacheService.class);
    private final NearCacheConfiguration config;
    private final ClientListenerNotifier listenerNotifier;
    private final AtomicInteger nearCacheRemovals = new AtomicInteger();
    private Object listener;
    private byte[] listenerId;
    private NearCache<K, V> cache;
    private Runnable invalidationCallback;
    private int bloomFilterBits = -1;
    private int bloomFilterUpdateThreshold;
    private InternalRemoteCache<K, V> remote;
    private SocketAddress listenerAddress;

    protected NearCacheService(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        this.config = config;
        this.listenerNotifier = listenerNotifier;
    }

    public SocketAddress start(InternalRemoteCache<K, V> remote2) {
        if (this.cache == null) {
            this.cache = this.createNearCache(this.config, this::entryRemovedFromNearCache);
            this.listener = new InvalidatedNearCacheListener(this);
            int maxEntries = this.config.maxEntries();
            if (maxEntries > 0 && this.config.bloomFilter()) {
                this.bloomFilterBits = NearCacheService.determineBloomFilterBits(maxEntries);
                this.bloomFilterUpdateThreshold = maxEntries / 16 + 3;
                this.listenerAddress = remote2.addNearCacheListener(this.listener, this.bloomFilterBits);
            } else {
                remote2.addClientListener(this.listener);
            }
            this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        }
        this.remote = remote2;
        return this.listenerAddress;
    }

    private static int determineBloomFilterBits(int maxEntries) {
        int bloomFilterBitScaler = Integer.parseInt(System.getProperty("infinispan.bloom-filter.bit-multiplier", "4"));
        return maxEntries * bloomFilterBitScaler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void entryRemovedFromNearCache(K key, MetadataValue<V> value) {
        while (true) {
            int removals;
            if ((removals = this.nearCacheRemovals.get()) >= this.bloomFilterUpdateThreshold) {
                if (!this.nearCacheRemovals.compareAndSet(removals, 0)) continue;
                this.remote.updateBloomFilter();
                return;
            }
            if (this.nearCacheRemovals.compareAndSet(removals, removals + 1)) return;
        }
    }

    public void stop(RemoteCache<K, V> remote2) {
        if (log.isTraceEnabled()) {
            log.tracef("Stop near cache, remove underlying listener id %s", (Object)Util.printArray(this.listenerId));
        }
        remote2.removeClientListener(this.listener);
        this.cache.clear();
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config, BiConsumer<K, MetadataValue<V>> removedConsumer) {
        return config.maxEntries() > 0 ? BoundedConcurrentMapNearCache.create(config, removedConsumer) : ConcurrentMapNearCache.create();
    }

    public static <K, V> NearCacheService<K, V> create(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        return new NearCacheService<K, V>(config, listenerNotifier);
    }

    @Override
    public void put(K key, MetadataValue<V> value) {
        this.cache.put(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Put key=%s and value=%s in near cache (listenerId=%s)", (Object)key, (Object)value, (Object)Util.printArray(this.listenerId));
        }
    }

    @Override
    public void putIfAbsent(K key, MetadataValue<V> value) {
        this.cache.putIfAbsent(key, value);
        if (log.isTraceEnabled()) {
            log.tracef("Conditionally put key=%s and value=%s if absent in near cache (listenerId=%s)", (Object)key, (Object)value, (Object)Util.printArray(this.listenerId));
        }
    }

    @Override
    public boolean remove(K key) {
        boolean removed = this.cache.remove(key);
        if (removed) {
            if (this.invalidationCallback != null) {
                this.invalidationCallback.run();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Removed key=%s from near cache (listenedId=%s)", (Object)key, (Object)Util.printArray(this.listenerId));
            }
        } else {
            log.tracef("Received false positive remove for key=%s from near cache (listenedId=%s)", (Object)key, (Object)Util.printArray(this.listenerId));
            this.entryRemovedFromNearCache(key, null);
        }
        return removed;
    }

    @Override
    public MetadataValue<V> get(K key) {
        boolean listenerConnected = this.isConnected();
        if (listenerConnected) {
            MetadataValue<V> value = this.cache.get(key);
            if (log.isTraceEnabled()) {
                log.tracef("Get key=%s returns value=%s (listenerId=%s)", (Object)key, (Object)value, (Object)Util.printArray(this.listenerId));
            }
            return value;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Near cache disconnected from server, returning null for key=%s (listenedId=%s)", (Object)key, (Object)Util.printArray(this.listenerId));
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (log.isTraceEnabled()) {
            log.tracef("Cleared near cache (listenerId=%s)", (Object)Util.printArray(this.listenerId));
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<K, MetadataValue<V>>> iterator() {
        return this.cache.iterator();
    }

    boolean isConnected() {
        return this.listenerNotifier.isListenerConnected(this.listenerId);
    }

    public void setInvalidationCallback(Runnable r) {
        this.invalidationCallback = r;
    }

    public int getBloomFilterBits() {
        return this.bloomFilterBits;
    }

    public byte[] getListenerId() {
        return this.listenerId;
    }

    public byte[] calculateBloomBits() {
        if (this.bloomFilterBits <= 0) {
            return null;
        }
        BloomFilter<byte[]> bloomFilter = MurmurHash3BloomFilter.createFilter(this.bloomFilterBits);
        for (Map.Entry entry : this.cache) {
            bloomFilter.addToFilter(this.remote.keyToBytes(entry.getKey()));
        }
        IntSet intSet = bloomFilter.getIntSet();
        return intSet.toBitSet();
    }

    @ClientListener
    private static class InvalidatedNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(InvalidatedNearCacheListener.class);
        private final NearCache<K, V> cache;

        private InvalidatedNearCacheListener(NearCache<K, V> cache) {
            this.cache = cache;
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryExpired
        public void handleExpiredEvent(ClientCacheEntryExpiredEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheFailover
        public void handleFailover(ClientCacheFailoverEvent e) {
            if (log.isTraceEnabled()) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private void invalidate(K key) {
            this.cache.remove(key);
        }
    }
}

