/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.pmml;

import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.definition.type.Role;
import org.kie.api.pmml.PMML4DataType;

@PropertyReactive
@Role(value=Role.Type.EVENT)
public abstract class PMML4Data<T>
implements PMML4DataType {
    private T value;
    private String name;
    private String correlationId;
    private boolean valid = false;
    private boolean missing = false;
    private boolean placeholder = false;
    private String context;
    private String displayName;
    private Double weight = 1.0;

    protected PMML4Data(String correlationId, String name, String context, boolean placeholder) {
        this.correlationId = correlationId;
        this.name = name;
        this.context = context;
        this.placeholder = placeholder;
    }

    protected PMML4Data(String correlationId, String name, String context, String displayName, T value) {
        this.correlationId = correlationId;
        this.name = name;
        this.context = context;
        this.displayName = displayName;
        this.value = value;
    }

    protected PMML4Data(String correlationId, String name, String context, String displayName, T value, Double weight) {
        this.correlationId = correlationId;
        this.name = name;
        this.context = context;
        this.displayName = displayName;
        this.value = value;
        this.weight = weight;
    }

    protected PMML4Data(String correlationId, String name, String context, String displayName, T value, Double weight, Boolean valid, Boolean missing) {
        this.correlationId = correlationId;
        this.name = name;
        this.context = context;
        this.displayName = displayName;
        this.value = value;
        this.weight = weight;
        this.valid = valid != null ? valid : false;
        this.missing = missing != null ? missing : false;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCapitalizedName() {
        return this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getDisplayValue() {
        return this.displayName;
    }

    public void setDisplayValue(String displayValue) {
        this.displayName = displayValue;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Class<?> getValueClass() {
        return this.value != null ? this.value.getClass() : null;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(Boolean placeholder) {
        this.placeholder = placeholder;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.context == null ? 0 : this.context.hashCode());
        result2 = 31 * result2 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result2 = 31 * result2 + (this.missing ? 1231 : 1237);
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.valid ? 1231 : 1237);
        result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
        result2 = 31 * result2 + (this.weight == null ? 0 : this.weight.hashCode());
        result2 = 31 * result2 + (this.placeholder ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMML4Data other = (PMML4Data)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.missing != other.missing) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.valid != other.valid) {
            return false;
        }
        if (this.placeholder != other.placeholder) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( name=" + this.getName() + ", context=" + this.getContext() + ", displayName=" + this.getDisplayValue() + ", missing=" + this.isMissing() + ", valid=" + this.isValid() + ", value=" + this.getValue().toString() + ", weight=" + this.getWeight() + ", placeholder=" + this.isPlaceholder() + " )";
    }
}

