/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server._private.ElytronMessages;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.permission.PermissionVerifier;

public class SimplePermissionMapper
implements PermissionMapper {
    private final MappingMode mappingMode;
    private final List<Mapping> mappings;

    private SimplePermissionMapper(MappingMode mappingMode, List<Mapping> mappings) {
        this.mappingMode = mappingMode;
        this.mappings = mappings;
    }

    @Override
    public PermissionVerifier mapPermissions(PermissionMappable permissionMappable, Roles roles) {
        Assert.checkNotNullParam("permissionMappable", permissionMappable);
        Assert.checkNotNullParam("roles", roles);
        PermissionVerifier result2 = null;
        for (Mapping current : this.mappings) {
            if (!current.principalPredicate.test(permissionMappable.getPrincipal().getName()) && !roles.containsAny(current.roles)) continue;
            switch (this.mappingMode) {
                case FIRST_MATCH: {
                    return current.permissionVerifier;
                }
                case AND: {
                    result2 = result2 != null ? result2.and(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case OR: {
                    result2 = result2 != null ? result2.or(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case UNLESS: {
                    result2 = result2 != null ? result2.unless(current.permissionVerifier) : current.permissionVerifier;
                    break;
                }
                case XOR: {
                    result2 = result2 != null ? result2.xor(current.permissionVerifier) : current.permissionVerifier;
                }
            }
        }
        return result2 != null ? result2 : PermissionVerifier.NONE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum MappingMode {
        FIRST_MATCH,
        AND,
        OR,
        XOR,
        UNLESS;

    }

    static class Mapping {
        final Predicate<String> principalPredicate;
        final Set<String> roles;
        final PermissionVerifier permissionVerifier;

        Mapping(Predicate<String> principalPredicate, Set<String> roles, PermissionVerifier permissionVerifier) {
            this.principalPredicate = principalPredicate;
            this.roles = Collections.unmodifiableSet(new HashSet(Assert.checkNotNullParam("roles", roles)));
            this.permissionVerifier = Assert.checkNotNullParam("permissionVerifier", permissionVerifier);
        }
    }

    public static class Builder {
        private boolean built = false;
        private MappingMode mappingMode = MappingMode.FIRST_MATCH;
        private final List<Mapping> mappings = new ArrayList<Mapping>();

        Builder() {
        }

        public Builder setMappingMode(MappingMode mappingMode) {
            this.assertNotBuilt();
            this.mappingMode = mappingMode;
            return this;
        }

        public Builder addMapping(Set<String> principals, Set<String> roles, PermissionVerifier permissionVerifier) {
            this.assertNotBuilt();
            this.mappings.add(new Mapping(new HashSet(Assert.checkNotNullParam("principals", principals))::contains, roles, permissionVerifier));
            return this;
        }

        public Builder addMatchAllPrincipals(PermissionVerifier permissionVerifier) {
            this.assertNotBuilt();
            this.mappings.add(new Mapping(name -> true, Collections.emptySet(), permissionVerifier));
            return this;
        }

        public PermissionMapper build() {
            this.assertNotBuilt();
            this.built = true;
            return new SimplePermissionMapper(this.mappingMode, this.mappings);
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw ElytronMessages.log.builderAlreadyBuilt();
            }
        }
    }
}

