/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import org.wildfly.security.ssl.ElytronMessages;

public enum KeyAgreement {
    ECDHE,
    RSA,
    DHr,
    DHd,
    DHE,
    PSK,
    FZA,
    KRB5,
    ECDHr,
    ECDHe,
    GOST,
    SRP,
    RSAPSK,
    DHEPSK,
    ECDHEPSK;

    static final int fullSize;

    static KeyAgreement forName(String name) {
        switch (name) {
            case "EECDH": 
            case "ECDHE": {
                return ECDHE;
            }
            case "RSA": {
                return RSA;
            }
            case "DHr": {
                return DHr;
            }
            case "DHd": {
                return DHd;
            }
            case "EDH": 
            case "DHE": {
                return DHE;
            }
            case "PSK": {
                return PSK;
            }
            case "FZA": {
                return FZA;
            }
            case "KRB5": {
                return KRB5;
            }
            case "ECDHr": {
                return ECDHr;
            }
            case "ECDHe": {
                return ECDHe;
            }
            case "GOST": {
                return GOST;
            }
            case "SRP": {
                return SRP;
            }
            case "RSAPSK": {
                return RSAPSK;
            }
            case "EDHPSK": 
            case "DHEPSK": {
                return DHEPSK;
            }
            case "ECDHEPSK": 
            case "EECDHPSK": {
                return ECDHEPSK;
            }
        }
        return null;
    }

    static KeyAgreement require(String name) {
        KeyAgreement keyAgreement = KeyAgreement.forName(name);
        if (keyAgreement == null) {
            throw ElytronMessages.log.unknownKeyExchangeName(name);
        }
        return keyAgreement;
    }

    public static boolean isFull(EnumSet<KeyAgreement> keyAgreements) {
        return keyAgreements != null && keyAgreements.size() == fullSize;
    }

    public boolean in(KeyAgreement value1, KeyAgreement value2) {
        return this == value1 || this == value2;
    }

    public boolean in(KeyAgreement value1, KeyAgreement value2, KeyAgreement value3) {
        return this == value1 || this == value2 || this == value3;
    }

    public boolean in(KeyAgreement ... values) {
        if (values != null) {
            for (KeyAgreement value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = KeyAgreement.values().length;
    }
}

