/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import java.util.List;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;

public final class ClientProxies {
    private ClientProxies() {
    }

    public static <T> T getApplicationScopedDelegate(InjectableContext applicationContext, InjectableBean<T> bean) {
        T result2 = applicationContext.get(bean);
        if (result2 == null) {
            result2 = applicationContext.get(bean, ClientProxies.newCreationalContext(bean));
        }
        return result2;
    }

    public static <T> T getDelegate(InjectableBean<T> bean) {
        List<InjectableContext> contexts = Arc.container().getContexts(bean.getScope());
        T result2 = null;
        if (contexts.size() == 1) {
            result2 = contexts.get(0).getIfActive(bean, ClientProxies::newCreationalContext);
        } else {
            InjectableContext selectedContext = null;
            for (int i = 0; i < contexts.size(); ++i) {
                InjectableContext context = contexts.get(i);
                if (result2 != null) {
                    if (!context.isActive()) continue;
                    throw new IllegalArgumentException("More than one context object for the given scope: " + selectedContext + " " + context);
                }
                result2 = context.getIfActive(bean, ClientProxies::newCreationalContext);
                if (result2 == null) continue;
                selectedContext = context;
            }
        }
        if (result2 == null) {
            throw new ContextNotActiveException();
        }
        return result2;
    }

    private static <T> CreationalContextImpl<T> newCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }
}

