/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniAndCombination;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class UniAndGroupIterable<T1> {
    private final Uni<? extends T1> source;
    private final List<? extends Uni<?>> unis;
    private boolean collectFailures;

    public UniAndGroupIterable(Iterable<? extends Uni<?>> iterable) {
        this(null, iterable, false);
    }

    public UniAndGroupIterable(Uni<? extends T1> source, Iterable<? extends Uni<?>> iterable) {
        this(source, iterable, false);
    }

    public UniAndGroupIterable(Uni<? extends T1> source, Iterable<? extends Uni<?>> iterable, boolean collectFailures) {
        this.source = source;
        List others = iterable instanceof List ? (List)iterable : StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        this.unis = others;
        this.collectFailures = collectFailures;
    }

    @CheckReturnValue
    public UniAndGroupIterable<T1> collectFailures() {
        this.collectFailures = true;
        return this;
    }

    @CheckReturnValue
    public <O> Uni<O> combinedWith(Function<List<?>, O> function) {
        Function<List<?>, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(function, "function"));
        return Infrastructure.onUniCreation(new UniAndCombination<T1, O>(this.source, this.unis, actual, this.collectFailures));
    }

    @Experimental(value="This is an experimental API")
    @CheckReturnValue
    public <O, I> Uni<O> combinedWith(Class<I> superType, Function<List<I>, O> function) {
        return this.combinedWith(function);
    }

    @CheckReturnValue
    public Uni<Void> discardItems() {
        return Infrastructure.onUniCreation(new UniAndCombination<T1, Void>(this.source, this.unis, x -> null, this.collectFailures));
    }
}

