/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.codegen.lang.TypeHelper;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodGenerator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class ConsumerMethodGenerator
extends MutinyMethodGenerator {
    public ConsumerMethodGenerator(PrintWriter writer) {
        super(writer);
    }

    public void generateDeclaration(MethodInfo method) {
        MutinyMethodDescriptor consumerMethod = this.computeMethodInfo(method);
        this.generateJavadoc(consumerMethod);
        this.generateMethodDeclaration(consumerMethod);
        this.writer.println(";");
        this.writer.println();
    }

    public void generate(MethodInfo method) {
        MutinyMethodDescriptor consumerMethod = this.computeMethodInfo(method);
        this.generateJavadoc(consumerMethod);
        this.generateMethodDeclaration(consumerMethod);
        this.generateBody(consumerMethod);
        this.writer.println();
    }

    private void generateBody(MutinyMethodDescriptor descriptor) {
        MethodInfo method = descriptor.getMethod();
        this.writer.println(" {");
        this.writer.print("    ");
        if (!method.getReturnType().isVoid()) {
            this.writer.print("return ");
        }
        this.writer.print("__" + method.getName() + "(");
        List<ParamInfo> params = method.getParams();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                this.writer.print(", ");
            }
            ParamInfo param2 = params.get(i);
            if (i < params.size() - 1) {
                this.writer.print(param2.getName());
                continue;
            }
            if (param2.getType().getName().startsWith(Uni.class.getName())) {
                this.writer.print(param2.getName());
                continue;
            }
            if (param2.getType().getName().equals(Runnable.class.getName())) {
                this.writer.println("ignored -> " + param2.getName() + ".run()");
                continue;
            }
            this.writer.print(param2.getName() + " != null ? " + param2.getName() + "::accept : null");
        }
        this.writer.println(");");
        this.writer.println("  }");
    }

    private MutinyMethodDescriptor computeMethodInfo(MethodInfo method) {
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>(method.getParams());
        ParamInfo handlerParameter = (ParamInfo)params.remove(method.getParams().size() - 1);
        TypeInfo consumerType = ((ParameterizedTypeInfo)handlerParameter.getType()).getArg(0);
        TypeInfo consumerUnresolvedType = ((ParameterizedTypeInfo)handlerParameter.getUnresolvedType()).getArg(0);
        TypeInfo consumer = new ParameterizedTypeInfo(TypeReflectionFactory.create(Consumer.class).getRaw(), consumerUnresolvedType.isNullable(), Collections.singletonList(consumerType));
        if (TypeHelper.isConsumerOfPromise(consumer)) {
            TypeInfo inner = ((ParameterizedTypeInfo)consumerType).getArg(0);
            consumer = new ParameterizedTypeInfo(TypeReflectionFactory.create(Uni.class).getRaw(), false, Collections.singletonList(inner));
        } else if (TypeHelper.isConsumerOfVoid(consumer)) {
            consumer = TypeReflectionFactory.create(Runnable.class);
        }
        params.add(new ParamInfo(params.size(), handlerParameter.getName(), handlerParameter.getDescription(), consumer));
        return new MutinyMethodDescriptor(method.copy().setParams(params), method, MutinyMethodDescriptor.MutinyKind.CONSUMER);
    }
}

