/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.literal.NamedLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigHelper {
    public static final String KAFKA_CONFIGURATION_NAME_ATTRIBUTE = "kafka-configuration";
    public static final String DEFAULT_KAFKA_BROKER = "default-kafka-broker";

    private ConfigHelper() {
    }

    public static Config retrieveChannelConfiguration(Instance<Map<String, Object>> instances, Config config) {
        Map<String, Object> defaultKafkaConfig = ConfigHelper.retrieveDefaultKafkaConfig(instances);
        Map<String, Object> channelSpecificConfig = ConfigHelper.getChannelSpecificConfig(instances, config);
        return ConfigHelper.merge(config, channelSpecificConfig, defaultKafkaConfig);
    }

    public static Config merge(final Config passedCfg, final Map<String, Object> defaultKafkaCfg) {
        return new Config(){

            @Override
            public <T> T getValue(String propertyName, Class<T> propertyType) {
                T passedCgfValue = passedCfg.getOptionalValue(propertyName, propertyType).orElse(null);
                if (passedCgfValue == null) {
                    Object o = defaultKafkaCfg.get(propertyName);
                    if (o == null) {
                        throw KafkaExceptions.ex.missingProperty(propertyName);
                    }
                    if (propertyType.isInstance(o)) {
                        return (T)o;
                    }
                    if (o instanceof String) {
                        Optional<Converter<Converter>> converter = passedCfg.getConverter(propertyType);
                        return (T)converter.map(conv -> conv.convert(o.toString())).orElseThrow(() -> new NoSuchElementException(propertyName));
                    }
                    throw KafkaExceptions.ex.cannotConvertProperty(propertyName, o.getClass(), propertyType);
                }
                return passedCgfValue;
            }

            @Override
            public ConfigValue getConfigValue(String propertyName) {
                return passedCfg.getConfigValue(propertyName);
            }

            @Override
            public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
                Optional<T> passedCfgValue = passedCfg.getOptionalValue(propertyName, propertyType);
                if (!passedCfgValue.isPresent()) {
                    Object o = defaultKafkaCfg.get(propertyName);
                    if (o == null) {
                        return Optional.empty();
                    }
                    if (propertyType.isInstance(o)) {
                        return Optional.of(o);
                    }
                    if (o instanceof String) {
                        Optional<Converter<Converter>> converter = passedCfg.getConverter(propertyType);
                        return converter.map(conv -> conv.convert(o.toString()));
                    }
                    return Optional.empty();
                }
                return passedCfgValue;
            }

            @Override
            public Iterable<String> getPropertyNames() {
                Iterable<String> names = passedCfg.getPropertyNames();
                HashSet<String> result2 = new HashSet<String>();
                names.forEach(result2::add);
                result2.addAll(defaultKafkaCfg.keySet());
                return result2;
            }

            @Override
            public Iterable<ConfigSource> getConfigSources() {
                return passedCfg.getConfigSources();
            }

            @Override
            public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
                return passedCfg.getConverter(forType);
            }

            @Override
            public <T> T unwrap(Class<T> type) {
                return passedCfg.unwrap(type);
            }
        };
    }

    public static Config merge(final Config passedCfg, final Map<String, Object> namedConfig, final Map<String, Object> defaultKafkaCfg) {
        if (namedConfig.isEmpty() && defaultKafkaCfg.isEmpty()) {
            return passedCfg;
        }
        return new Config(){

            private <T> T extractValue(String name, Class<T> clazz, boolean failIfMissing) {
                Object value = passedCfg.getOptionalValue(name, clazz).orElse(null);
                if (value != null) {
                    return (T)value;
                }
                value = namedConfig.getOrDefault(name, defaultKafkaCfg.get(name));
                if (value == null) {
                    if (failIfMissing) {
                        throw KafkaExceptions.ex.missingProperty(name);
                    }
                    return null;
                }
                if (clazz.isInstance(value)) {
                    return (T)value;
                }
                if (value instanceof String) {
                    String v = (String)value;
                    Optional<Converter<T>> converter = passedCfg.getConverter(clazz);
                    if (converter.isPresent()) {
                        return converter.get().convert(v);
                    }
                    if (failIfMissing) {
                        throw KafkaExceptions.ex.missingProperty(name);
                    }
                    return null;
                }
                if (failIfMissing) {
                    throw KafkaExceptions.ex.cannotConvertProperty(name, value.getClass(), clazz);
                }
                return null;
            }

            @Override
            public <T> T getValue(String propertyName, Class<T> propertyType) {
                return this.extractValue(propertyName, propertyType, true);
            }

            @Override
            public ConfigValue getConfigValue(String propertyName) {
                return passedCfg.getConfigValue(propertyName);
            }

            @Override
            public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
                T value = this.extractValue(propertyName, propertyType, false);
                return Optional.ofNullable(value);
            }

            @Override
            public Iterable<String> getPropertyNames() {
                HashSet<String> result2 = new HashSet<String>();
                result2.addAll(defaultKafkaCfg.keySet());
                result2.addAll(namedConfig.keySet());
                Iterable<String> names = passedCfg.getPropertyNames();
                names.forEach(result2::add);
                return result2;
            }

            @Override
            public Iterable<ConfigSource> getConfigSources() {
                return passedCfg.getConfigSources();
            }

            @Override
            public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
                return passedCfg.getConverter(forType);
            }

            @Override
            public <T> T unwrap(Class<T> type) {
                return passedCfg.unwrap(type);
            }
        };
    }

    public static Map<String, Object> retrieveDefaultKafkaConfig(Instance<Map<String, Object>> instances) {
        Instance<Map<String, Object>> defaultKafkaConfigurationInstance = instances.select(Identifier.Literal.of(DEFAULT_KAFKA_BROKER));
        if (defaultKafkaConfigurationInstance.isUnsatisfied() && !(defaultKafkaConfigurationInstance = instances.select(NamedLiteral.of(DEFAULT_KAFKA_BROKER))).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        Map defaultKafkaConfig = Collections.emptyMap();
        if (!defaultKafkaConfigurationInstance.isUnsatisfied()) {
            defaultKafkaConfig = (Map)defaultKafkaConfigurationInstance.get();
        }
        return defaultKafkaConfig;
    }

    public static Map<String, Object> getChannelSpecificConfig(Instance<Map<String, Object>> instances, Config config) {
        Optional<String> name = config.getOptionalValue(KAFKA_CONFIGURATION_NAME_ATTRIBUTE, String.class);
        Optional<String> channel = config.getOptionalValue("channel-name", String.class);
        String channelName = channel.orElse(null);
        Map<String, Object> channelSpecificConfig = Collections.emptyMap();
        if (name.isPresent()) {
            channelSpecificConfig = ConfigHelper.lookupForIdentifiedConfiguration(instances, name.get(), false);
        } else if (channelName != null) {
            channelSpecificConfig = ConfigHelper.lookupForIdentifiedConfiguration(instances, channelName, true);
        }
        return channelSpecificConfig;
    }

    public static Map<String, Object> lookupForIdentifiedConfiguration(Instance<Map<String, Object>> instances, String identifier, boolean optional) {
        Instance<Map<String, Object>> instance = instances.select(Identifier.Literal.of(identifier));
        if (instance.isUnsatisfied()) {
            if (!optional) {
                throw new UnsatisfiedResolutionException("Cannot find the Kafka configuration: " + identifier);
            }
            return Collections.emptyMap();
        }
        return (Map)instance.get();
    }
}

