/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Utils;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    private final FetchRequestData data;
    private final Map<TopicPartition, PartitionData> fetchData;
    private final List<TopicPartition> toForget;
    private final FetchMetadata metadata;

    private Optional<Integer> optionalEpoch(int rawEpochValue) {
        if (rawEpochValue < 0) {
            return Optional.empty();
        }
        return Optional.of(rawEpochValue);
    }

    private Map<TopicPartition, PartitionData> toPartitionDataMap(List<FetchRequestData.FetchTopic> fetchableTopics) {
        LinkedHashMap result2 = new LinkedHashMap();
        fetchableTopics.forEach(fetchTopic -> fetchTopic.partitions().forEach(fetchPartition -> result2.put(new TopicPartition(fetchTopic.topic(), fetchPartition.partition()), new PartitionData(fetchPartition.fetchOffset(), fetchPartition.logStartOffset(), fetchPartition.partitionMaxBytes(), this.optionalEpoch(fetchPartition.currentLeaderEpoch()), this.optionalEpoch(fetchPartition.lastFetchedEpoch())))));
        return Collections.unmodifiableMap(result2);
    }

    private List<TopicPartition> toForgottenTopicList(List<FetchRequestData.ForgottenTopic> forgottenTopics) {
        ArrayList<TopicPartition> result2 = new ArrayList<TopicPartition>();
        forgottenTopics.forEach(forgottenTopic -> forgottenTopic.partitions().forEach(partitionId -> result2.add(new TopicPartition(forgottenTopic.topic(), (int)partitionId))));
        return result2;
    }

    public FetchRequest(FetchRequestData fetchRequestData, short version) {
        super(ApiKeys.FETCH, version);
        this.data = fetchRequestData;
        this.fetchData = this.toPartitionDataMap(fetchRequestData.topics());
        this.toForget = this.toForgottenTopicList(fetchRequestData.forgottenTopicsData());
        this.metadata = new FetchMetadata(fetchRequestData.sessionId(), fetchRequestData.sessionEpoch());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.fetchData.entrySet()) {
            responseData.put(entry.getKey(), FetchResponse.partitionResponse(entry.getKey().partition(), error));
        }
        return FetchResponse.of(error, throttleTimeMs, this.data.sessionId(), responseData);
    }

    public int replicaId() {
        return this.data.replicaId();
    }

    public int maxWait() {
        return this.data.maxWaitMs();
    }

    public int minBytes() {
        return this.data.minBytes();
    }

    public int maxBytes() {
        return this.data.maxBytes();
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public List<TopicPartition> toForget() {
        return this.toForget;
    }

    public boolean isFromFollower() {
        return this.replicaId() >= 0;
    }

    public IsolationLevel isolationLevel() {
        return IsolationLevel.forId(this.data.isolationLevel());
    }

    public FetchMetadata metadata() {
        return this.metadata;
    }

    public String rackId() {
        return this.data.rackId();
    }

    public static FetchRequest parse(ByteBuffer buffer, short version) {
        return new FetchRequest(new FetchRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public FetchRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchRequest> {
        private final int maxWait;
        private final int minBytes;
        private final int replicaId;
        private final Map<TopicPartition, PartitionData> fetchData;
        private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        private int maxBytes = Integer.MAX_VALUE;
        private FetchMetadata metadata = FetchMetadata.LEGACY;
        private List<TopicPartition> toForget = Collections.emptyList();
        private String rackId = "";

        public static Builder forConsumer(int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(ApiKeys.FETCH.oldestVersion(), ApiKeys.FETCH.latestVersion(), -1, maxWait, minBytes, fetchData);
        }

        public static Builder forReplica(short allowedVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(allowedVersion, allowedVersion, replicaId, maxWait, minBytes, fetchData);
        }

        public Builder(short minVersion, short maxVersion, int replicaId, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            super(ApiKeys.FETCH, minVersion, maxVersion);
            this.replicaId = replicaId;
            this.maxWait = maxWait;
            this.minBytes = minBytes;
            this.fetchData = fetchData;
        }

        public Builder isolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        public Builder metadata(FetchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder rackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public Map<TopicPartition, PartitionData> fetchData() {
            return this.fetchData;
        }

        public Builder setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public List<TopicPartition> toForget() {
            return this.toForget;
        }

        public Builder toForget(List<TopicPartition> toForget) {
            this.toForget = toForget;
            return this;
        }

        @Override
        public FetchRequest build(short version) {
            if (version < 3) {
                this.maxBytes = Integer.MAX_VALUE;
            }
            FetchRequestData fetchRequestData = new FetchRequestData();
            fetchRequestData.setReplicaId(this.replicaId);
            fetchRequestData.setMaxWaitMs(this.maxWait);
            fetchRequestData.setMinBytes(this.minBytes);
            fetchRequestData.setMaxBytes(this.maxBytes);
            fetchRequestData.setIsolationLevel(this.isolationLevel.id());
            fetchRequestData.setForgottenTopicsData(new ArrayList<FetchRequestData.ForgottenTopic>());
            this.toForget.stream().collect(Collectors.groupingBy(TopicPartition::topic, LinkedHashMap::new, Collectors.toList())).forEach((topic, partitions) -> fetchRequestData.forgottenTopicsData().add(new FetchRequestData.ForgottenTopic().setTopic((String)topic).setPartitions(partitions.stream().map(TopicPartition::partition).collect(Collectors.toList()))));
            fetchRequestData.setTopics(new ArrayList<FetchRequestData.FetchTopic>());
            FetchRequestData.FetchTopic fetchTopic = null;
            for (Map.Entry<TopicPartition, PartitionData> entry : this.fetchData.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                PartitionData partitionData = entry.getValue();
                if (fetchTopic == null || !topicPartition.topic().equals(fetchTopic.topic())) {
                    fetchTopic = new FetchRequestData.FetchTopic().setTopic(topicPartition.topic()).setPartitions(new ArrayList<FetchRequestData.FetchPartition>());
                    fetchRequestData.topics().add(fetchTopic);
                }
                FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setPartition(topicPartition.partition()).setCurrentLeaderEpoch(partitionData.currentLeaderEpoch.orElse(-1)).setLastFetchedEpoch(partitionData.lastFetchedEpoch.orElse(-1)).setFetchOffset(partitionData.fetchOffset).setLogStartOffset(partitionData.logStartOffset).setPartitionMaxBytes(partitionData.maxBytes);
                fetchTopic.partitions().add(fetchPartition);
            }
            if (this.metadata != null) {
                fetchRequestData.setSessionEpoch(this.metadata.epoch());
                fetchRequestData.setSessionId(this.metadata.sessionId());
            }
            fetchRequestData.setRackId(this.rackId);
            return new FetchRequest(fetchRequestData, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=FetchRequest").append(", replicaId=").append(this.replicaId).append(", maxWait=").append(this.maxWait).append(", minBytes=").append(this.minBytes).append(", maxBytes=").append(this.maxBytes).append(", fetchData=").append(this.fetchData).append(", isolationLevel=").append((Object)this.isolationLevel).append(", toForget=").append(Utils.join(this.toForget, ", ")).append(", metadata=").append(this.metadata).append(", rackId=").append(this.rackId).append(")");
            return bld.toString();
        }
    }

    public static final class PartitionData {
        public final long fetchOffset;
        public final long logStartOffset;
        public final int maxBytes;
        public final Optional<Integer> currentLeaderEpoch;
        public final Optional<Integer> lastFetchedEpoch;

        public PartitionData(long fetchOffset, long logStartOffset, int maxBytes, Optional<Integer> currentLeaderEpoch) {
            this(fetchOffset, logStartOffset, maxBytes, currentLeaderEpoch, Optional.empty());
        }

        public PartitionData(long fetchOffset, long logStartOffset, int maxBytes, Optional<Integer> currentLeaderEpoch, Optional<Integer> lastFetchedEpoch) {
            this.fetchOffset = fetchOffset;
            this.logStartOffset = logStartOffset;
            this.maxBytes = maxBytes;
            this.currentLeaderEpoch = currentLeaderEpoch;
            this.lastFetchedEpoch = lastFetchedEpoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.fetchOffset == that.fetchOffset && this.logStartOffset == that.logStartOffset && this.maxBytes == that.maxBytes && Objects.equals(this.currentLeaderEpoch, that.currentLeaderEpoch) && Objects.equals(this.lastFetchedEpoch, that.lastFetchedEpoch);
        }

        public int hashCode() {
            return Objects.hash(this.fetchOffset, this.logStartOffset, this.maxBytes, this.currentLeaderEpoch, this.lastFetchedEpoch);
        }

        public String toString() {
            return "PartitionData(fetchOffset=" + this.fetchOffset + ", logStartOffset=" + this.logStartOffset + ", maxBytes=" + this.maxBytes + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", lastFetchedEpoch=" + this.lastFetchedEpoch + ')';
        }
    }
}

