/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.options;

import java.util.Objects;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

public final class OptionDescriptor {
    private final OptionKey<?> key;
    private final String name;
    private final String help;
    private final OptionCategory category;
    private final OptionStability stability;
    private final boolean deprecated;
    private final String deprecationMessage;
    private static final OptionDescriptor EMPTY = new OptionDescriptor(null, null, null, null, null, false, null);

    OptionDescriptor(OptionKey<?> key, String name, String help2, OptionCategory category, OptionStability stability, boolean deprecated2, String deprecationMessage) {
        this.key = key;
        this.name = name;
        this.help = help2;
        this.category = category;
        this.stability = stability;
        this.deprecated = deprecated2;
        this.deprecationMessage = deprecationMessage;
    }

    public String getName() {
        return this.name;
    }

    public OptionKey<?> getKey() {
        return this.key;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }

    public boolean isOptionMap() {
        return this.getKey().getType().isOptionMap();
    }

    public OptionCategory getCategory() {
        return this.category;
    }

    public OptionStability getStability() {
        return this.stability;
    }

    public String getHelp() {
        return this.help;
    }

    public String toString() {
        return "OptionDescriptor [key=" + this.key + ", help=" + this.help + ", category=" + (Object)((Object)this.category) + ", deprecated=" + this.deprecated + ", optionMap=" + this.isOptionMap() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.deprecated ? 1231 : 1237);
        result2 = 31 * result2 + (this.help == null ? 0 : this.help.hashCode());
        result2 = 31 * result2 + (this.key == null ? 0 : this.key.hashCode());
        result2 = 31 * result2 + (this.category == null ? 0 : this.category.hashCode());
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionDescriptor other = (OptionDescriptor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.deprecated, other.deprecated) && Objects.equals(this.help, other.help) && Objects.equals(this.key, other.key) && Objects.equals((Object)this.category, (Object)other.category);
    }

    public static <T> Builder newBuilder(OptionKey<T> key, String name) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(name);
        OptionDescriptor optionDescriptor = EMPTY;
        optionDescriptor.getClass();
        return optionDescriptor.new Builder(key, name);
    }

    public final class Builder {
        private final OptionKey<?> key;
        private final String name;
        private boolean deprecated = false;
        private String deprecationMessage = "";
        private OptionCategory category = OptionCategory.INTERNAL;
        private OptionStability stability = OptionStability.EXPERIMENTAL;
        private String help = "";

        Builder(OptionKey<?> key, String name) {
            this.key = key;
            this.name = name;
        }

        public Builder category(OptionCategory category) {
            Objects.requireNonNull(category);
            this.category = category;
            return this;
        }

        public Builder stability(OptionStability stability) {
            Objects.requireNonNull(stability);
            this.stability = stability;
            return this;
        }

        public Builder deprecated(boolean deprecated2) {
            this.deprecated = deprecated2;
            return this;
        }

        public Builder help(String help2) {
            Objects.requireNonNull(help2);
            this.help = help2;
            return this;
        }

        public Builder deprecationMessage(String deprecationMessage) {
            Objects.requireNonNull(deprecationMessage);
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public OptionDescriptor build() {
            return new OptionDescriptor(this.key, this.name, this.help, this.category, this.stability, this.deprecated, this.deprecationMessage);
        }
    }
}

